<?php

defined('TEMPLAZA_FRAMEWORK') or exit();
// -> START Shop Section
Templaza_API::set_section('settings', array(
        'title' => esc_html__( 'Woocommerce Options', 'tzautoshowroom'),
        'id'    => 'Woocommerce-options',
        'icon'  => 'el el-shopping-cart'
    )
);
Templaza_API::set_section('settings',
    array(
        'title'      => esc_html__( 'Product Catalog', 'tzautoshowroom' ),
        'id'         => 'shop-page',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-layout',
                'type'     => 'select',
                'title'    => esc_html__('Shop Layout', 'tzautoshowroom'),
                'subtitle' => esc_html__('Default style list or grid for Shop page.', 'tzautoshowroom'),
                'options'  => array(
                    'grid' => esc_html__('Grid', 'tzautoshowroom'),
                    'masonry' => esc_html__('Masonry', 'tzautoshowroom'),
                ),
                'default'  => 'grid',
            ),
            array(
                'id'       => 'templaza-shop-column-large',
                'type'     => 'select',
                'title'    => esc_html__('Large Desktop Columns', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number products per row large desktop (1600px and larger)', 'tzautoshowroom'),
                'options'  => array(
                    '1' => esc_html__('1 Column', 'tzautoshowroom'),
                    '2' => esc_html__('2 Column', 'tzautoshowroom'),
                    '3' => esc_html__('3 Column', 'tzautoshowroom'),
                    '4' => esc_html__('4 Column', 'tzautoshowroom'),
                    '5' => esc_html__('5 Column', 'tzautoshowroom'),
                    '6' => esc_html__('6 Column', 'tzautoshowroom'),
                ),
                'default'  => '3',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-column',
                'type'     => 'select',
                'title'    => esc_html__('Desktop Columns', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number products per row (1200px and larger)', 'tzautoshowroom'),
                'options'  => array(
                    '1' => esc_html__('1 Column', 'tzautoshowroom'),
                    '2' => esc_html__('2 Column', 'tzautoshowroom'),
                    '3' => esc_html__('3 Column', 'tzautoshowroom'),
                    '4' => esc_html__('4 Column', 'tzautoshowroom'),
                    '5' => esc_html__('5 Column', 'tzautoshowroom'),
                    '6' => esc_html__('6 Column', 'tzautoshowroom'),
                ),
                'default'  => '3',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-column-laptop',
                'type'     => 'select',
                'title'    => esc_html__('Laptop Columns', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number products per row (960px and larger)', 'tzautoshowroom'),
                'options'  => array(
                    '1' => esc_html__('1 Column', 'tzautoshowroom'),
                    '2' => esc_html__('2 Column', 'tzautoshowroom'),
                    '3' => esc_html__('3 Column', 'tzautoshowroom'),
                    '4' => esc_html__('4 Column', 'tzautoshowroom'),
                    '5' => esc_html__('5 Column', 'tzautoshowroom'),
                    '6' => esc_html__('6 Column', 'tzautoshowroom'),
                ),
                'default'  => '3',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-column-tablet',
                'type'     => 'select',
                'title'    => esc_html__('Tablet Columns', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number products per row (640px and larger)', 'tzautoshowroom'),
                'options'  => array(
                    '1' => esc_html__('1 Column', 'tzautoshowroom'),
                    '2' => esc_html__('2 Column', 'tzautoshowroom'),
                    '3' => esc_html__('3 Column', 'tzautoshowroom'),
                    '4' => esc_html__('4 Column', 'tzautoshowroom'),
                    '5' => esc_html__('5 Column', 'tzautoshowroom'),
                    '6' => esc_html__('6 Column', 'tzautoshowroom'),
                ),
                'default'  => '2',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-column-mobile',
                'type'     => 'select',
                'title'    => esc_html__('Mobile Columns', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number products per row mobile', 'tzautoshowroom'),
                'options'  => array(
                    '1' => esc_html__('1 Column', 'tzautoshowroom'),
                    '2' => esc_html__('2 Column', 'tzautoshowroom'),
                    '3' => esc_html__('3 Column', 'tzautoshowroom'),
                    '4' => esc_html__('4 Column', 'tzautoshowroom'),
                    '5' => esc_html__('5 Column', 'tzautoshowroom'),
                    '6' => esc_html__('6 Column', 'tzautoshowroom'),
                ),
                'default'  => '1',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-column-gap',
                'type'     => 'select',
                'title'    => esc_html__('Column Gap', 'tzautoshowroom'),
                'subtitle' => esc_html__('Column Gap grid.', 'tzautoshowroom'),
                'options'  => array(
                    'default' => esc_html__('Default','tzautoshowroom'),
                    'small' => esc_html__('Small','tzautoshowroom'),
                    'medium' => esc_html__('Medium','tzautoshowroom'),
                    'large' => esc_html__('Large','tzautoshowroom'),
                    'collapse' => esc_html__('Collapse','tzautoshowroom'),
                ),
                'default'  => 'default',
                'required' => array('templaza-shop-layout', '=' , 'grid')
            ),
            array(
                'id'       => 'templaza-shop-products_per_page',
                'type'     => 'spinner',
                'title'    => esc_html__('Products per page.', 'tzautoshowroom'),
                'subtitle' => esc_html__('Products per page.', 'tzautoshowroom'),
                'default'  => '9',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
            ),
            array(
                'id'     => 'templaza-shop-padding',
                'type'   => 'spacing',
                'mode'   => 'padding',
                'all'    => false,
                'allow_responsive'    => true,
                'units'  => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
                'title'  => esc_html__('Item Padding', 'tzautoshowroom'),
                'select2'   => array('allowClear' => true),
            ),
            array(
                'id'     => 'templaza-shop-margin',
                'type'   => 'spacing',
                'mode'   => 'margin',
                'all'    => false,
                'allow_responsive'    => true,
                'units'  => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
                'title'  => esc_html__('Item Margin', 'tzautoshowroom'),
                'select2'   => array('allowClear' => true),
            ),

            array(
                'id'       => 'templaza-shop-pagination',
                'type'     => 'select',
                'title'    => esc_html__('Shop Pagination', 'tzautoshowroom'),
                'subtitle' => esc_html__('Pagination Type.', 'tzautoshowroom'),
                'options'  => array(
                    'number' => esc_html__('Number','tzautoshowroom'),
                    'loadmore' => esc_html__('Button Load more','tzautoshowroom'),
                    'scroll' => esc_html__('Infinite Scroll','tzautoshowroom'),
                ),
                'default'  => 'number',
            ),
            array(
                'id'       => 'templaza_shop_show_title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Title', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Show/hide Title.', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza_shop_show_rating',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Rating', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Show/hide Rating.', 'tzautoshowroom' ),
                'default'  => true,
            ),
        )
    )
);

// Product Loop Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Product Loop', 'tzautoshowroom' ),
        'id'         => 'shop-product-loop',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-loop-layout',
                'type'     => 'select',
                'title'    => esc_html__('Product Loop Layout', 'tzautoshowroom'),
                'options'  => array(
                    'layout-1' => esc_html__( 'Icons over thumbnail on hover', 'tzautoshowroom' ),
                    'layout-2' => esc_html__( 'Icons & Quick view button', 'tzautoshowroom' ),
                    'layout-3' => esc_html__( 'Icons & Add to cart button', 'tzautoshowroom' ),
                    'layout-4' => esc_html__( 'Icons on the bottom', 'tzautoshowroom' ),
                    'layout-5' => esc_html__( 'Simple', 'tzautoshowroom' ),
                    'layout-6' => esc_html__( 'Standard button', 'tzautoshowroom' ),
                    'layout-7' => esc_html__( 'Info on hover', 'tzautoshowroom' ),
                    'layout-8' => esc_html__( 'Icons & Add to cart text', 'tzautoshowroom' ),
                    'layout-9' => esc_html__( 'Quick Shop button', 'tzautoshowroom' ),
                ),
                'default'  => 'layout-1',
            ),
            array(
                'id'       => 'templaza-shop-loop-hover',
                'type'     => 'select',
                'title'    => esc_html__('Product Loop Hover', 'tzautoshowroom'),
                'options'  => array(
                    'classic' => esc_html__( 'Default', 'tzautoshowroom' ),
                    'slider'  => esc_html__( 'Slider', 'tzautoshowroom' ),
                    'fadein'  => esc_html__( 'Fadein', 'tzautoshowroom' ),
                    'zoom'    => esc_html__( 'Zoom', 'tzautoshowroom' ),
                ),
                'default'  => 'classic',
                'required' => array('templaza-shop-loop-layout', '!=' , 'layout-7'),
            ),
            array(
                'id'       => 'templaza-shop-loop-featured-icons',
                'type'     => 'checkbox',
                'title'    => esc_html__('Featured Icons', 'tzautoshowroom'),

                //Must provide key => value pairs for multi checkbox options
                'options'  => array(
                    'cart'  => esc_html__( 'Cart', 'tzautoshowroom' ),
                    'quickview' => esc_html__( 'Quick View', 'tzautoshowroom' ),
                    'wishlist' => esc_html__( 'Wishlist', 'tzautoshowroom' ),
                ),
                //See how default has changed? you also don't need to specify opts that are 0.
                'default' => array(
                    'cart' => '1',
                    'quickview' => '1',
                    'wishlist' => '1'
                ),
                'required' => array('templaza-shop-loop-layout', '!=' , 'layout-5'),
            ),
            array(
                'id'       => 'templaza-shop-loop-wishlist',
                'type'     => 'switch',
                'title'    => esc_html__( 'Always Display Wishlist', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-loop-layout', '=' , array('layout-2','layout-3','layout-9')),
            ),
            array(
                'id'       => 'templaza-shop-loop-attributes',
                'type'     => 'checkbox',
                'title'    => esc_html__('Attributes', 'tzautoshowroom'),

                //Must provide key => value pairs for multi checkbox options
                'options'  => array(
                    'taxonomy' => esc_html__( 'Taxonomy', 'tzautoshowroom' ),
                    'rating'   => esc_html__( 'Rating', 'tzautoshowroom' ),
                ),
                //See how default has changed? you also don't need to specify opts that are 0.
                'default' => array(
                    'taxonomy' => '1',
                    'rating' => '0',
                ),
            ),
            array(
                'id'       => 'templaza-shop-loop-taxonomy',
                'type'     => 'select',
                'title'    => esc_html__('Product Loop Taxonomy', 'tzautoshowroom'),
                'options'  => array(
                    'product_cat'   => esc_html__( 'Category', 'tzautoshowroom' ),
                    'product_brand' => esc_html__( 'Brand', 'tzautoshowroom' ),
                ),
                'default'  => 'product_cat',
                'required' => array(
                    array( 'templaza-shop-loop-attributes', '=', 'taxonomy' ),
                    array( 'templaza-shop-loop-attributes', '=', '1' )
                ),
            ),
            array(
                'id'       => 'templaza-shop-loop-variation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Variations', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-loop-layout', '=' , array('layout-8','layout-9')),
            ),
            array(
                'id'       => 'templaza-shop-loop-variation-ajax',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Variations With AJAX', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array(
                    array( 'templaza-shop-loop-variation', '=', true ),
                    array( 'templaza-shop-loop-layout', '=', 'layout-9' )
                ),
            ),
            array(
                'id'       => 'templaza-shop-loop-description',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Description', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-loop-layout', '=' , 'layout-6'),
            ),
            array(
                'id'       => 'templaza-shop-loop-description-length',
                'type'     => 'spinner',
                'title'    => esc_html__('Description Length', 'tzautoshowroom'),
                'default'  => '10',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
                'required' => array('templaza-shop-loop-layout', '=' , 'layout-6'),
            ),
        )
    )
);
//  Product Notifications Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Product Notifications', 'tzautoshowroom' ),
        'id'         => 'shop-notify',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-notify',
                'type'     => 'select',
                'title'    => esc_html__('Added to Cart Notice', 'tzautoshowroom'),
                'subtitle' => esc_html__('Show notice when click add to cart button.', 'tzautoshowroom'),
                'options'  => array(
                    'panel'  => esc_html__( 'Open mini cart panel', 'tzautoshowroom' ),
                    'popup'  => esc_html__( 'Open cart popup', 'tzautoshowroom' ),
                    'simple' => esc_html__( 'Simple', 'tzautoshowroom' ),
                    'none'   => esc_html__( 'None', 'tzautoshowroom' ),
                ),
                'default'  => 'panel',
            ),
            array(
                'id'       => 'templaza-shop-notify-popup',
                'type'     => 'select',
                'title'    => esc_html__('Recommended Products', 'tzautoshowroom'),
                'subtitle' => esc_html__('Display Recommend product in popup.', 'tzautoshowroom'),
                'options'  => array(
                    'none'                  => esc_html__( 'None', 'tzautoshowroom' ),
                    'best_selling_products' => esc_html__( 'Best selling products', 'tzautoshowroom' ),
                    'featured_products'     => esc_html__( 'Featured products', 'tzautoshowroom' ),
                    'recent_products'       => esc_html__( 'Recent products', 'tzautoshowroom' ),
                    'sale_products'         => esc_html__( 'Sale products', 'tzautoshowroom' ),
                    'top_rated_products'    => esc_html__( 'Top rated products', 'tzautoshowroom' ),
                    'related_products'      => esc_html__( 'Related products', 'tzautoshowroom' ),
                    'upsells_products'      => esc_html__( 'Upsells products', 'tzautoshowroom' ),
                ),
                'default'  => 'related_products',
                'required' => array('templaza-shop-notify', '=' , 'popup'),
            ),
            array(
                'id'       => 'templaza-shop-notify-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Recommend Title', 'tzautoshowroom' ),
                'default'  => esc_html__( 'You may also like', 'tzautoshowroom' ),
                'required' => array('templaza-shop-notify', '=' , 'popup'),
            ),
            array(
                'id'       => 'templaza-shop-notify-product-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Number of products', 'tzautoshowroom'),
                'default'  => '6',
                'min'      => '1',
                'step'     => '1',
                'max'      => '20',
                'required' => array('templaza-shop-notify', '=' , 'popup'),
            ),
            array(
                'id'       => 'templaza-shop-notify-autohide',
                'type'     => 'spinner',
                'title'    => esc_html__('Cart Notification Auto Hide', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number seconds you want to hide the notification.', 'tzautoshowroom'),
                'default'  => '3',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
                'required' => array('templaza-shop-notify', '=' , 'simple'),
            ),
            array(
                'id'       => 'templaza-shop-notify-wishlist',
                'type'     => 'switch',
                'title'    => esc_html__( 'Added to Wishlist Notification', 'tzautoshowroom' ),
                'default'  => false,
            ),
            array(
                'id'       => 'templaza-shop-notify-wishlist-autohide',
                'type'     => 'spinner',
                'title'    => esc_html__('Wishlist Notification Auto Hide', 'tzautoshowroom'),
                'subtitle' => esc_html__('Number seconds you want to hide the notification.', 'tzautoshowroom'),
                'default'  => '3',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
                'required' => array('templaza-shop-notify-wishlist', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-single-image-lightbox',
                'type'     => 'switch',
                'title'    => esc_html__( 'Image Light box', 'tzautoshowroom' ),
                'default'  => false,
            ),
        )
    )
);
// Single Product Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Single Product', 'tzautoshowroom' ),
        'id'         => 'shop-single',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-single-layout',
                'type'     => 'select',
                'title'    => esc_html__('Single Product Layout', 'tzautoshowroom'),
                'options'  => array(
                    'layout-1' => esc_html__( 'Layout 1', 'tzautoshowroom' ),
                    'layout-2' => esc_html__( 'Layout 2', 'tzautoshowroom' ),
                    'layout-3' => esc_html__( 'Layout 3', 'tzautoshowroom' ),
                    'layout-4' => esc_html__( 'Layout 4', 'tzautoshowroom' ),
                    'layout-5' => esc_html__( 'Layout 5', 'tzautoshowroom' ),
                ),
                'default'  => 'layout-1',
            ),
            array(
                'id'       => 'templaza-shop-single-cart-ajax',
                'type'     => 'switch',
                'title'    => esc_html__( 'Add to cart with AJAX ', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-single-cart-sticky',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sticky Add To Cart', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-single-cart-sticky-pos',
                'type'     => 'select',
                'title'    => esc_html__('Cart sticky position', 'tzautoshowroom'),
                'options'  => array(
                    'top'   => esc_html__( 'Top', 'tzautoshowroom' ),
                    'bottom' => esc_html__( 'Bottom', 'tzautoshowroom' ),

                ),
                'default'  => 'top',
                'required' => array('templaza-shop-single-cart-sticky', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-single-cart-sticky-atc-variable',
                'type'     => 'select',
                'title'    => esc_html__('Product Variable Style', 'tzautoshowroom'),
                'options'  => array(
                    'button'   => esc_html__( 'Button', 'tzautoshowroom' ),
                    'form' => esc_html__( 'Add to cart form', 'tzautoshowroom' ),

                ),
                'default'  => 'button',
                'required' => array('templaza-shop-single-cart-sticky', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-single-taxonomy',
                'type'     => 'select',
                'title'    => esc_html__('Product Taxonomy', 'tzautoshowroom'),
                'subtitle' => esc_html__( 'Show taxonomy above product title.', 'tzautoshowroom' ),
                'options'  => array(
                    'product_cat'   => esc_html__( 'Category', 'tzautoshowroom' ),
                    'product_brand' => esc_html__( 'Brand', 'tzautoshowroom' ),
                    ''              => esc_html__( 'None', 'tzautoshowroom' ),

                ),
                'default'  => '',
            ),
            array(
                'id'       => 'templaza-shop-single-brand-type',
                'type'     => 'select',
                'title'    => esc_html__('Product Brand type', 'tzautoshowroom'),
                'options'  => array(
                    'title'   => esc_html__( 'Title', 'tzautoshowroom' ),
                    'logo' => esc_html__( 'Logo', 'tzautoshowroom' ),
                ),
                'default'  => 'title',
                'required' => array('templaza-shop-single-taxonomy', '=' , 'product_brand'),
            ),
            array(
                'id'       => 'templaza-shop-single-wishlist',
                'type'     => 'select',
                'title'    => esc_html__('Wishlist button', 'tzautoshowroom'),
                'options'  => array(
                    'icon' => esc_html__('Icon','tzautoshowroom'),
                    'title' => esc_html__('Icon & Title','tzautoshowroom'),
                ),
                'default'  => 'icon',
            ),
            array(
                'id'       => 'templaza-shop-single-image-zoom',
                'type'     => 'switch',
                'title'    => esc_html__( 'Image Zoom', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Zoom image when hover', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-single-image-lightbox',
                'type'     => 'switch',
                'title'    => esc_html__( 'Image Light box', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-single-thumb-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Thumbnail Slider Numbers', 'tzautoshowroom'),
                'default'  => '4',
                'min'      => '1',
                'step'     => '1',
                'max'      => '20',
            ),
            array(
                'id'       => 'templaza-shop-single-meta',
                'type'     => 'checkbox',
                'title'    => esc_html__('Product Meta', 'tzautoshowroom'),
                //Must provide key => value pairs for multi checkbox options
                'options'  => array(
                    'sku'      => esc_html__( 'Sku', 'tzautoshowroom' ),
                    'tags'     => esc_html__( 'Tags', 'tzautoshowroom' ),
                    'category' => esc_html__( 'Category', 'tzautoshowroom' ),
                ),
                //See how default has changed? you also don't need to specify opts that are 0.
                'default' => array(
                    'sku' => '1',
                    'tags' => '1',
                    'category' => '1'
                ),
            ),
            array(
                'id'       => 'templaza-shop-single-content-tabs',
                'type'     => 'select',
                'title'    => esc_html__('Content Tabs Position', 'tzautoshowroom'),
                'options'  => array(
                    'default' => esc_html__('Under Slider','tzautoshowroom'),
                    'under_summary' => esc_html__('Under Product meta','tzautoshowroom'),
                ),
                'default'  => 'default',
            ),

        )
    )
);
// Related Product Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Related Products', 'tzautoshowroom' ),
        'id'         => 'shop-related',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Related Products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-related-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Related Title', 'tzautoshowroom' ),
                'default'  => esc_html__( 'Related Products', 'tzautoshowroom' ),
                'required' => array('templaza-shop-related', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-related-category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Products by categories', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-related', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-related-parent-category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Products by parent category', 'tzautoshowroom' ),
                'default'  => false,
                'required' => array('templaza-shop-related', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-related-tag',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Products by tags', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-related', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-related-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Related Products Numbers', 'tzautoshowroom'),
                'default'  => '4',
                'min'      => '1',
                'step'     => '1',
                'max'      => '50',
                'required' => array('templaza-shop-related', '=' , true),
            ),

        )
    )
);
// Upsells Product Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Upsells Products ', 'tzautoshowroom' ),
        'id'         => 'shop-upsells',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-upsells',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Upsells Products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-upsells-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Upsells Title', 'tzautoshowroom' ),
                'default'  => esc_html__( 'You may also like', 'tzautoshowroom' ),
                'required' => array('templaza-shop-upsells', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-upsells-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Upsells Products Numbers', 'tzautoshowroom'),
                'default'  => '6',
                'min'      => '1',
                'step'     => '1',
                'max'      => '50',
                'required' => array('templaza-shop-upsells', '=' , true),
            ),

        )
    )
);
// Recent Viewed Product Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Recent Viewed Products ', 'tzautoshowroom' ),
        'id'         => 'shop-recent-viewed',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-recent-viewed',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Recent Viewed Products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-recent-viewed-ajax',
                'type'     => 'switch',
                'title'    => esc_html__( 'Load With Ajax', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-recent-viewed-empty',
                'type'     => 'switch',
                'title'    => esc_html__('Hide Empty Products', 'tzautoshowroom' ),
                'subtitle'    => esc_html__('Check this option to hide the recently viewed products when empty.', 'tzautoshowroom' ),
                'default'  => true,
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-recent-viewed-page',
                'type'     => 'checkbox',
                'title'    => esc_html__('Display on page', 'tzautoshowroom'),
                //Must provide key => value pairs for multi checkbox options
                'options'  => array(
                    'single'   => esc_html__('Single Product', 'tzautoshowroom'),
                    'catalog'  => esc_html__('Catalog Page', 'tzautoshowroom'),
                    'cart'     => esc_html__('Cart Page', 'tzautoshowroom'),
                    'checkout' => esc_html__('Checkout Page', 'tzautoshowroom'),
                ),
                //See how default has changed? you also don't need to specify opts that are 0.
                'default' => array(
                    'single' => '1',
                    'catalog' => '0',
                    'cart' => '0',
                    'checkout' => '0'
                ),
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),

            array(
                'id'       => 'templaza-shop-recent-viewed-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Recently Viewed Title', 'tzautoshowroom' ),
                'default'  => esc_html__( 'Recently Viewed', 'tzautoshowroom' ),
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'    => 'templaza-shop-recent-viewed-readmore-text',
                'type'  => 'text',
                'title' => esc_html__( 'Read more text', 'tzautoshowroom' ),
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'    => 'templaza-shop-recent-viewed-readmore-url',
                'type'  => 'text',
                'title' => esc_html__( 'Read more url', 'tzautoshowroom' ),
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-recent-viewed-columns',
                'type'     => 'spinner',
                'title'    => esc_html__('Recent viewed columns', 'tzautoshowroom'),
                'default'  => '4',
                'min'      => '1',
                'step'     => '1',
                'max'      => '50',
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-recent-viewed-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Recent viewed numbers', 'tzautoshowroom'),
                'default'  => '6',
                'min'      => '1',
                'step'     => '1',
                'max'      => '50',
                'required' => array('templaza-shop-recent-viewed', '=' , true),
            ),

        )
    )
);
// Badge Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Product Badges', 'tzautoshowroom' ),
        'id'         => 'shop-badge',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-catalog-badges',
                'type'     => 'switch',
                'title'    => esc_html__( 'Catalog Badges', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display the badges in the catalog page', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-catalog-badges-layout',
                'type'     => 'select',
                'title'    => esc_html__('Badges Layout', 'tzautoshowroom'),
                'subtitle' => esc_html__('Badges Layout.', 'tzautoshowroom'),
                'options'  => array(
                    'layout-1' => esc_html__('Layout 1','tzautoshowroom'),
                    'layout-2' => esc_html__('Layout 2','tzautoshowroom'),
                ),
                'required' => array('templaza-shop-catalog-badges', '=' , true),
                'default'  => 'layout-1',
            ),
            array(
                'id'       => 'templaza-shop-single-badges',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Badges', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display the badges in the single page', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-badge-sale',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Sale Badge', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display a badge for sale products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-badge-sale-type',
                'type'     => 'select',
                'title'    => esc_html__('Badges Sale type', 'tzautoshowroom'),
                'options'  => array(
                    'percent' => esc_html__('Percent','tzautoshowroom'),
                    'text' => esc_html__('Text','tzautoshowroom'),
                    'both' => esc_html__('Both','tzautoshowroom'),
                ),
                'required' => array('templaza-shop-badge-sale', '=' , true),
                'default'  => 'text',
            ),
            array(
                'id'       => 'templaza-shop-badge-sale-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Badge Sale text', 'tzautoshowroom' ),
                'desc'     => esc_html__( 'Use {%} to display discount percent, {$} to display discount amount.', 'tzautoshowroom' ),
                'default'  => esc_html__( 'Sale', 'tzautoshowroom' ),
            ),
            array(
                'id'       => 'templaza-shop-badge-new',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable New Badge', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display a badge for new products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-badge-new-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Badge New text', 'tzautoshowroom' ),
                'default'  => esc_html__( 'New', 'tzautoshowroom' ),
                'required' => array('templaza-shop-badge-new', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-new-day',
                'type'     => 'spinner',
                'title'    => esc_html__('Product Newness', 'tzautoshowroom'),
                'desc'     => esc_html__('Display the "New" badge for how many days?', 'tzautoshowroom'),
                'default'  => '5',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
                'required' => array('templaza-shop-badge-new', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-badge-featured',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Featured Badge', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display a badge for featured products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-badge-featured-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Badge Featured text', 'tzautoshowroom' ),
                'default'  => esc_html__( 'Hot', 'tzautoshowroom' ),
                'required' => array('templaza-shop-badge-featured', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-badge-soldout',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Sold Out Badge', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Display a badge for out of stock products', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-badge-soldout-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Badge Sold out text', 'tzautoshowroom' ),
                'default'  => esc_html__( 'Sold Out', 'tzautoshowroom' ),
                'required' => array('templaza-shop-badge-soldout', '=' , true),
            ),


        )
    )
);

// Cart Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Cart Page', 'tzautoshowroom' ),
        'id'         => 'shop-cart',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-cart-auto',
                'type'     => 'switch',
                'title'    => esc_html__( 'Update Cart Automatically', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Automatically update cart when change product', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-cart-cross',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Cross-Sells Products ', 'tzautoshowroom' ),
                'default'  => true,
            ),
            array(
                'id'       => 'templaza-shop-cart-cross-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Cross-Sells Products Title', 'tzautoshowroom' ),
                'default'  => esc_html__( 'You may also like', 'tzautoshowroom' ),
                'required' => array('templaza-shop-cart-cross', '=' , true),
            ),
            array(
                'id'       => 'templaza-shop-cart-cross-number',
                'type'     => 'spinner',
                'title'    => esc_html__('Cross-Sells Products Numbers', 'tzautoshowroom'),
                'default'  => '6',
                'min'      => '1',
                'step'     => '1',
                'max'      => '500',
                'required' => array('templaza-shop-cart-cross', '=' , true),
            ),
        )
    )
);
// Login Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Mini cart', 'tzautoshowroom' ),
        'id'         => 'mini-cart',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-mini-cart',
                'type'     => 'select',
                'title'    => esc_html__('Login type', 'tzautoshowroom'),
                'options'  => array(
                    'modal' => esc_html__('Modal','tzautoshowroom'),
                    'link' => esc_html__('Link','tzautoshowroom'),
                ),
                'default'  => 'modal',
            ),
        )
    )
);
// Login Setting
Templaza_API::set_subsection('settings', 'shop-page',
    array(
        'title'      => esc_html__( 'Account Login', 'tzautoshowroom' ),
        'id'         => 'account-login',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'templaza-shop-account-login',
                'type'     => 'select',
                'title'    => esc_html__('Login type', 'tzautoshowroom'),
                'options'  => array(
                    'modal' => esc_html__('Modal','tzautoshowroom'),
                    'link' => esc_html__('Link','tzautoshowroom'),
                ),
                'default'  => 'modal',
            ),
            array(
                'id'       => 'templaza-shop-account-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Login text', 'tzautoshowroom' ),
            ),
            array(
                'id'          => 'templaza-shop-account-icon',
                'type'        => 'select',
                'title'       => esc_html__( 'Login icon', 'tzautoshowroom' ),
                'data'        => 'fontawesome',
            ),

        )
    )
);