<?php

defined('DEALERSHIP') or die();

use DealerShip\Helpers\QueryHelper;

extract(shortcode_atts(array(
    'id'                    => uniqid(),
    'tz_id'                 => '',
    'tz_css'                => '',
    'tz_class'              => '',
    'login_type'        => 'icon',
    'login_icon'        => 'fas fa-user',
    'login_icon_color'  => '',
    'login_text'        => __('Login', 'dealership'),
    'logged_text'        => __('My Account', 'dealership'),
    'login_style'       => 'modal',
), $atts));
if($navs = $this -> get_navigations()){
    global $wp;

    $user       = wp_get_current_user();
    $lnavattr   = '';
    $lstyleId   = 'dls-login-'.uniqid();

    if(!empty($login_icon_color) && is_string($login_icon_color)) {
        $login_icon_color   = json_decode($login_icon_color, true);
    }

    if(!$user -> ID && isset($login_style) && in_array($login_style, array('modal', 'off-canvas'))){
        $lnavattr   = ' data-uk-toggle="target: #'.$lstyleId.'"';
    }
?>
<div<?php echo isset($tz_id)?' id="'.$tz_id.'"':''; ?>  class="<?php echo $tz_class; ?>">
    <a href="#" class="dls-login-icon"<?php echo $lnavattr;?>>
        <?php if(in_array($login_type, array('icon', 'icon_text'))){?>
            <span class="<?php echo $login_icon;?>"></span>
        <?php } ?>
        <?php
        if(in_array($login_type, array('text', 'icon_text'))){
            if($user -> ID){
                echo (isset($logged_text) && !empty($logged_text))?$logged_text:'';
            }else{
                echo (isset($login_text) && !empty($login_text))?$login_text:'';
            }
        }?>
    </a>
    <?php if($user -> ID){ ?>
        <div data-uk-dropdown>
            <ul class="uk-nav uk-nav-default">
                <li class="<?php echo !QueryHelper::get_current_endpoint()?'uk-active':''; ?>">
                    <a href="<?php echo QueryHelper::get_endpoint_url(''); ?>"><?php _e('Dashboard', 'dealership');?></a>
                </li>
                <?php foreach ($navs as $key => $var){
                    $endpoint   = QueryHelper::get_endpoint_name($var);
                    $url        = QueryHelper::get_endpoint_url($endpoint);
                    if($key == 'customer-logout'){
                        $url    = wp_nonce_url($url, 'dls_customer-logout');
                    }
                    $item_next  = next($navs);

                    $has_child  = $item_next && isset($item_next['parent']) && $item_next['parent'] == $key;
                    $class  = isset($wp -> query_vars[$endpoint])?'uk-active':'';
                    $class .= $has_child?' uk-parent':'';
                    $class .= ' '.$key.'';
                    ?>
                <li class="<?php echo $class; ?>"><a href="<?php echo esc_url($url); ?>"><?php
                        echo QueryHelper::get_endpoint_title($key);  ?></a></li>
                <?php }?>
            </ul>
        </div>
    <?php }else{?>
        <?php if($login_style == 'modal'){ ?>
        <div id="<?php echo $lstyleId; ?>" class="dls-login-modal uk-flex-top" data-uk-modal>
            <div class="uk-modal-dialog uk-margin-auto-vertical">
                <button class="uk-modal-close-default uk-text-secondary" type="button" data-uk-close></button>
                <div class="uk-modal-header">
                    <h3 class="uk-modal-title"><?php echo __('Sign In', 'dealership');?></h3>
                </div>
                <div class="uk-modal-body">
                    <?php echo do_shortcode('[dealership form_name="login"]');?>
                </div>
            </div>
        </div>
        <?php }elseif ($login_style == 'off-canvas'){ ?>
        <div id="<?php echo $lstyleId; ?>" class="dls-login-off-canvas" data-uk-offcanvas="flip: true">
            <div class="uk-offcanvas-bar">
                <button class="uk-offcanvas-close" type="button" data-uk-close></button>
                <div class="uk-grid-collapse uk-child-width-1-1 uk-height-1-1 uk-flex-wrap-middle" data-uk-grid>
<!--                    <h3>--><?php //echo __('Sign In', 'dealership');?><!--</h3>-->
                    <?php echo do_shortcode('[dealership form_name="login"]');?>
                </div>
            </div>
        </div>
        <?php }else{ ?>
            <div data-uk-dropdown class="uk-card uk-card-default uk-width-medium">
                <?php echo do_shortcode('[dealership form_name="login"]');?>
            </div>
        <?php } ?>
    <?php }?>
</div>
<?php } ?>