<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Function;
use Advanced_Product\AP_Templates;
use DealerShip\Helpers\ProductHelper;

$products   = ProductHelper::get_products(array(
    'post_status' => 'any',
));

if($products && $products -> have_posts() && class_exists('Advanced_Product\AP_Templates')) {
    ?>
<div class="dls-product-items uk-child-width-1-3@l uk-child-width-1-3@xl uk-child-width-1-3@m uk-child-width-1-2@s uk-child-width-1-1 uk-grid-default" data-uk-grid>
    <?php while($products -> have_posts()){?>
        <div class="dls-product-item uk-transition-toggle uk-position-relative">
            <div class="dealer-product-item uk-position-relative">
                <?php

                do_action('dealership/my-account/products/before_content');
                $products -> the_post();
                $product_stt = get_post_status(get_the_ID());
                AP_Templates::load_my_layout('archive.content-item-dealer');
                if($product_stt == 'pending' || $product_stt == 'draft'){
                    ?>
                    <div class="uk-position-top-left uk-margin-top product-stt-box uk-alert-warning">
                        <div class="uk-margin-small-left uk-margin-small-right product-stt"><?php echo esc_html($product_stt);?></div>
                    </div>
                    <?php
                }
                if($product_stt == 'publish'){
                    ?>
                    <div class="uk-position-top-left uk-margin-top product-stt-box  uk-alert-success">
                        <div class="uk-margin-small-left uk-margin-small-right product-stt"><?php echo esc_html($product_stt);?></div>
                    </div>
                    <?php
                }
                do_action('dealership/my-account/products/after_content');
                ?>
            </div>
        </div>
    <?php }?>
</div>
<?php
    wp_reset_postdata();
}else{
?>
<div class="uk-alert-primary" data-uk-alert>
    <p><?php _e('No matching results.', 'dealership');?></p>
</div>
<?php } ?>
