<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Function;

global $post_id;

extract($args);

$fields = $instance -> get_fields();
$user   = wp_get_current_user();
?>
<div class="field_form">
    <?php
    if( is_array($fields) ){
        echo '<form method="post" id="dealership_edit-account" data-uk-grid>';

        do_action( "dealership_before_form", $args );

        $role_id    = isset($_REQUEST['id'])?$_REQUEST['id']:'';
        $options    = !empty($role_id)?get_option('dls_role_'.$role_id.'_meta'):array();

        foreach( $fields as $field ){

            // if they didn't select a type, skip this field
            if( !$field || !$field['type'] || $field['type'] == 'null' )
            {
                continue;
            }

            // apply filters
            $field = apply_filters('acf/load_field_defaults', $field);

            // set value
            if( !isset($field['value']))
            {
                $field['value'] = isset($options[$field['name']])?$options[$field['name']]:null;

                if(isset($user -> {$field['name']})){
                    $field['value'] = $user -> {$field['name']};
                }

//                // Set field is true when role is administrator
//                if($field['value'] == null && $role_id == 'administrator'){
//                    $field['value'] = 1;
//                }
            }

            // required
            $required_class = "";
            $required_label = "";

            if(!empty($field) && isset( $field['required']) && $field['required'] )
            {
                $required_class = ' required';
                $required_label = ' <span class="required">*</span>';
            }

            echo '<div id="acf-' . $field['name'] . '" class="uk-width-1-2@s field field_type-' . $field['type'] . ' field_key-' . $field['key'] . $required_class . '" data-field_name="' . $field['name'] . '" data-field_key="' . $field['key'] . '" data-field_type="' . $field['type'] . '">';

            echo '<p class="label">';
            echo '<label for="' . $field['id'] . '">' . $field['label'] . $required_label . '</label>';
            echo $field['instructions'];
            echo '</p>';

//            $field['name'] = '[' . $field['name'] . ']';
            do_action('acf/create_field', $field, $post_id);

            echo '</div>';

        }
        wp_nonce_field( 'dls_edit_user_form');
        echo '<div class="uk-width-1-1"><button class="templaza-btn uk-button uk-margin-top">'.__('Save changes', 'dealership').'</button></div>';

        do_action( 'dealership_after_form_fields', $args );
        echo '</form>';
    }
    ?>
</div>