<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Function;
use DealerShip\Helpers\QueryHelper;

$user = wp_get_current_user();

$logout_link    = wp_nonce_url(QueryHelper::get_endpoint_url('customer-logout'), 'dls_customer-logout');
$logout_link    = '<a href="'.esc_url($logout_link).'">'.QueryHelper::get_endpoint_title('customer-logout').'</a>';
?>
<p><?php echo sprintf(__('Hello %s (not %s? %s)', 'dealership'), $user->display_name,$user -> display_name, $logout_link);?></p>
<div class="uk-grid-small uk-child-width-1-3" data-uk-grid>
    <div class="dealer-dashboard-info">
        <h5 class="uk-text-default uk-text-bold uk-margin-small">
            <?php esc_html_e('Email', 'dealership'); ?>
        </h5>
        <div class="uk-text-small">
            <?php echo $user -> user_email; ?>
        </div>
    </div>
    <div>
        <h5 class="uk-text-default uk-text-bold uk-margin-small">
            <?php  esc_html_e('Website', 'dealership'); ?>
        </h5>
        <div class="uk-text-small">
            <a href="<?php echo $user -> user_url; ?>">
                <?php echo $user -> user_url; ?>
            </a>
        </div>
    </div>
    <?php
    $map_location   = get_field('_dls_map_location', 'user_'.$user -> ID);
    if(!empty($map_location)){
    ?>
    <div class="uk-width-1-1">
        <h5 class="uk-text-default uk-text-bold uk-margin-small">
            <?php  esc_html_e('Map Location', 'dealership'); ?>
        </h5>
        <div class="uk-text-small">
            <?php
            $map_url    = 'https://maps.google.com/maps?';
            $map_url   .= 'q='.urlencode($map_location);
            $map_url   .= '&t=m';
            $map_url   .= '&z=10';
            $map_url   .= '&output=embed';
            $map_url   .= '&iwloc=near';
            ?>
            <iframe src="<?php echo esc_url($map_url); ?>" class="uk-height-medium uk-width-1-1"></iframe>
        </div>
    </div>
    <?php } ?>
</div>