<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Template;
use DealerShip\Helpers\QueryHelper;

$endpoint   = QueryHelper::get_endpoint_layout();

$endpoint   = ($endpoint == QueryHelper::get_endpoint_name('add-product'))?'edit-product':$endpoint;
$user       = wp_get_current_user();
$class      = !get_theme_support('templaza-framework')?' dls-max-width-none':'';
?>

<div class="dealer-page<?php echo $class; ?>">
    <?php DLS_Template::load_my_layout('notice', true, false, $args); ?>
    <div data-uk-grid>
        <div class="uk-width-1-4@m dealer-page-left">
            <div class="uk-card uk-card-default uk-card-body sidebar-bg" data-uk-sticky="end: !.dealer-page; offset: 100">
                <div class="dealer-header-left">
                    <div class="uk-width-auto uk-text-center ">
                        <img class="uk-border-circle dealer-avatar" src="<?php echo get_avatar_url($user -> ID); ?>" width="100" height="100" alt="<?php
                        echo $user ->display_name;?>"/>

                        <h3 class="dealer-title uk-text-center uk-margin-top"><?php echo $user -> display_name;?></h3>
                    </div>
                </div>
                <?php
                DLS_Template::load_my_layout('navigation', true, false, $args);
                ?>
            </div>
        </div>
        <div class="uk-width-expand@m dealer-page-right">
            <div class="uk-card uk-card-default uk-card-body">
                <?php
                DLS_Template::load_my_layout('my-account.'.$endpoint, true, false, $args);
                ?>
            </div>
        </div>
    </div>
</div>