<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Function;
use DealerShip\DLS_Template;
use DealerShip\Helpers\QueryHelper;

global $post_id;

extract($args);

$fields = $instance -> get_fields();
?>
<form method="post" id="dealership_login">
    <div class="field_form">
        <?php
        if( is_array($fields) && count($fields) ){

            DLS_Template::load_my_layout('notice', true, false, array());

            do_action( "dealership_before_form", $args );

            $role_id    = isset($_REQUEST['id'])?$_REQUEST['id']:'';
            $options    = !empty($role_id)?get_option('dls_role_'.$role_id.'_meta'):array();

            foreach( $fields as $field ){

                // if they didn't select a type, skip this field
                if( !$field || !$field['type'] || $field['type'] == 'null' )
                {
                    continue;
                }

                // apply filters
                $field = apply_filters('acf/load_field_defaults', $field);

                // set value
                if( !isset($field['value']))
                {
                    $field['value'] = isset($options[$field['name']])?$options[$field['name']]:null;

                    // Set field is true when role is administrator
                    if($field['value'] == null && $role_id == 'administrator'){
                        $field['value'] = 1;
                    }
                }

                // required
                $required_class = "";
                $required_label = "";

                if(!empty($field) && isset( $field['required']) && $field['required'] )
                {
                    $required_class = ' required';
                    $required_label = ' <span class="required">*</span>';
                }

                echo '<div id="acf-' . $field['name'] . '" class="uk-margin field field_type-' . $field['type'] . ' field_key-' . $field['key'] . $required_class . '" data-field_name="' . $field['name'] . '" data-field_key="' . $field['key'] . '" data-field_type="' . $field['type'] . '">';

                echo '<div class="label">';
                echo '<label for="' . $field['id'] . '" class="uk-form-label">' . $field['label'] . $required_label . '</label>';
                echo isset($field['instructions'])?$field['instructions']:'';
                echo '</div>';

    //            $field['name'] = '[' . $field['name'] . ']';
                do_action('acf/create_field', $field, $post_id);

                echo '</div>';

            }
            echo '<div class="dls-field">';
            echo '<label><input type="checkbox" class="checkbox" name="rememberme" value="1"><span>'.
                __('Remember Me', 'dealership').'</span></label>';
            echo '</div>';
            wp_nonce_field( 'dls_login_form', 'dealership-login-nonce', false );
            echo '<button class="templaza-btn uk-button uk-width-1-1 uk-margin-small-top" name="login" value="'.__('Login', 'dealership').'"><span>'.__('Login', 'dealership').'</span></button>';

            if(get_option('users_can_register')){
                echo '<div class="uk-text-center uk-margin-top"><a href="'.QueryHelper::get_main_permalink(get_option('options_dealership_register_page_id',
                            get_option('options_dealership_myaccount_page_id',0))).'" >'
                    .__("Don't have an account?", 'dealership').'</a></div>';
            }

            do_action( 'dls_after_form_fields', $args );
        }
        ?>
    </div>
</form>