<?php

namespace DealerShip\TemplazaFramework\Elements;

use DealerShip\Helpers\QueryHelper;
use DealerShip\TemplazaFramework\Interfaces\Element;
use TemPlazaFramework\CSS;
use TemPlazaFramework\Templates;

defined('DEALERSHIP') or die();

class DealerMenu extends Element {

    public function register(){
        return array(
            'id'          => $this -> get_name(),
            'title'       => __('Dealer Menu', 'dealership'),
            'icon'        => 'el el-leaf',
            'param_title' => esc_html__('Dealer Menu Settings', 'dealership'),
            'desc'        => __('Load a dealer menu', 'dealership'),
            'admin_label' => true,
            'params'      => array(
                array(
                    'id'        => 'login_type',
                    'type'      => 'select',
                    'default'   => 'icon',
                    'title'     => __('Login Type', 'dealership'),
                    'options'   => array(
                        'icon'  => __('Icon', 'dealership'),
                        'text'  => __('Text', 'dealership'),
                        'icon_text'  => __('Icon & Text', 'dealership')
                    ),
                ),
                array(
                    'id'        => 'login_icon',
                    'type'      => 'select',
                    'data'      => 'fontawesome',
                    'default'   => 'fas fa-user',
                    'required'  => array(
                        'login_type', '=', array('icon', 'icon_text')
                    ),
                    'title'     => __('Login Icon', 'dealership'),
                    'subtitle'  => __('Select icon', 'dealership'),
                ),
                array(
                    'id'        => 'login_icon_color',
                    'type'      => 'color_rgba',
                    'required'  => array(
                        'login_type', '=', array('icon', 'icon_text')
                    ),
                    'title'     => __('Login Icon Color', 'dealership'),
                    'subtitle'  => __('Select icon color', 'dealership'),
                ),
                array(
                    'id'        => 'login_text',
                    'type'      => 'text',
                    'required'  => array(
                        'login_type', '=', array('text', 'icon_text')
                    ),
                    'default'   => __('Login', 'dealership'),
                    'title'     => __('Login Text', 'dealership'),
                ),
                array(
                    'id'        => 'logged_text',
                    'type'      => 'text',
                    'required'  => array(
                        'login_type', '=', array('text', 'icon_text')
                    ),
                    'default'   => __('My Account', 'dealership'),
                    'title'     => __('Logged Text', 'dealership'),
                ),
                array(
                    'id'        => 'login_style',
                    'type'      => 'select',
                    'default'   => 'modal',
                    'title'     => __('Login Style', 'dealership'),
                    'options'   => array(
                        'modal'     => __('Modal', 'dealership'),
                        'dropdown'  => __('Dropdown', 'dealership'),
                        'off-canvas'=> __('Off-Canvas', 'dealership'),
                    )
                ),

            )
        );
    }

    public function get_shortcode_name()
    {
        return $this -> get_name();
    }

    public function get_navigations(){
        $query_vars = QueryHelper::get_query_vars();

        if(!$query_vars){
            return array();
        }

        $menus  = array();
        foreach ($query_vars as $key => $var){
            if(isset($var['navigation']) && !$var['navigation']){
                continue;
            }

            $menus[$key]    = $var;
        }

        return $menus;
    }

    public function shortcode($atts, $content = '')
    {
        $html   = parent::shortcode($atts, $content);

        if(!empty($html) && preg_match('/<form.*id="(dealership_login)"/', $html)){
            $html   = preg_replace('/(<form.*id=")(dealership_login)(")/', '$1$2-form-'.$atts['id'].'$3', $html);
        }
        if(!empty($html) && preg_match_all('/(<\s*input[^>]*)(class=")(.*?\>)/im', $html, $match)){
            $html   = preg_replace('/(<\s*input[^>]*)(class=")(.*?\>)/im', '$1$2uk-input $3', $html);
        }

        return $html;
    }

    public function prepare_params($params, $element, $parent_el)
    {
        $login_icon_color = isset($params['login_icon_color'])?$params['login_icon_color']:'';

        if(!empty($login_icon_color)) {
            $custom_css_name = '.tz_custom_' . $element['id'] . ' ';
            $style = $custom_css_name.' .dls-login-icon{color:'.CSS::make_color_rgba_redux($login_icon_color).';}';

            Templates::add_inline_style($style);
        }

        return parent::prepare_params($params, $element, $parent_el);
    }
}
