<?php
namespace DealerShip\ShortCodes;

use Advanced_Product\ACF_Taxonomy_Walker;
use Advanced_Product\AP_Functions;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use Advanced_Product\Helper\AP_Custom_Taxonomy_Helper;
use DealerShip\DLS_Function;
use DealerShip\DLS_Template;
use DealerShip\Frontend\EndPoints\ProductEP;
use DealerShip\Helpers\QueryHelper;
use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\BaseHelper;
use DealerShip\Interfaces\Notice;
use DealerShip\Interfaces\Session;
use DealerShip\Interfaces\ShortCode;
use Advanced_Product\Helper\FieldHelper;

defined('DEALERSHIP') or exit();

class DealerShipSC extends ShortCode{

    protected $error;
    protected $message;
    protected $end_points   = array();
    protected $query_vars   = array();

    public function __construct()
    {
        $this -> query_vars = QueryHelper::get_query_vars();

        parent::__construct();

        if(!$this -> message){
            $this -> message = new \stdClass();
            $this -> message -> type    = '';
            $this -> message -> message = '';
        }

        $this -> __load_endpoints();
    }

    public function hooks(){
        add_action( 'init', array( $this, 'add_endpoints' ) );

        if(!is_admin()) {
            add_filter( 'query_vars', array( $this, 'add_query_vars' ), 0 );
            add_filter('body_class', array($this, 'body_class'));
            add_action( 'parse_request', array( $this, 'parse_request' ), 0 );
            add_action('wp_enqueue_scripts', array($this, 'register_scripts'));
            add_action('template_redirect', array($this, 'redirect_to_login_page'));
        }

        // Use a custom walker for the ACF dropdowns
        // Change taxonomy id to slug
        add_filter('acf/fields/taxonomy/wp_list_categories', array($this, 'acf_wp_list_categories'), 10, 2);

    }

    protected function __load_endpoints(){
        $path   = DEALERSHIP_ENDPOINTS_PATH;
        if(!$path || ($path && !is_dir($path))){
            return false;
        }

        $files  = glob($path.'/*.php');

        if(count($files)){
            foreach ($files as $file){
                $info = pathinfo($file);
                $file_name  = $info['filename'];

                $class_name = 'DealerShip\Frontend\EndPoints\\'.ucfirst(str_replace('-', '_', $file_name));

                if(class_exists($class_name)){
                    $page_obj  = \call_user_func(array($class_name, 'instance'));
                    $this -> end_points[$file_name] = $page_obj;
                }
            }
        }
    }

    public function body_class($classes){
        global $post;
        if(is_a( $post, 'WP_Post' ) && has_shortcode($post -> post_content, $this -> get_shortcode_name())){
            $classes[]  = 'dls-dealership-page';
        }
        return $classes;
    }

    public function acf_wp_list_categories( $args, $field ) {
        $ap_taxonomies  = array('ap_branch', 'ap_category');

        if(($ap_custom_taxonomies = AP_Custom_Taxonomy_Helper::get_taxonomies()) && is_array($ap_custom_taxonomies)) {
            $ap_taxonomies = array_merge($ap_taxonomies,$ap_custom_taxonomies);
        }

        if(in_array($args['taxonomy'], $ap_taxonomies)) {
            $args['walker'] = new ACF_Taxonomy_Walker($field);
        }
        return $args;
    }

    /**
     * Add endpoints for query vars.
     */
    public function add_endpoints() {
        $mask = QueryHelper::get_endpoints_mask();

        $query_vars = $this -> query_vars;

        global $wp_rewrite;
        foreach ( $query_vars as $key => $var ) {
            $endpoint   = QueryHelper::get_endpoint_name($var);
            if ( ! empty( $endpoint ) ) {
                \add_rewrite_endpoint( $endpoint, $mask );
                do_action('dealership/shortcode/add_endpoint/after', $endpoint, $key, $var, $mask);
            }
        }
        $wp_rewrite->flush_rules();
    }

    /**
     * Add query vars.
     *
     * @param array $vars Query vars.
     * @return array
     */
    public function add_query_vars( $vars ) {
        $query_vars = $this -> query_vars;

        foreach ( $query_vars as $key => $var ) {
            $endpoint   = QueryHelper::get_endpoint_name($var);
            $vars[] = $endpoint;
            $vars   = apply_filters('dealership/shortcode/add_query_var/after', $vars, $endpoint, $key, $var);
        }
        return $vars;
    }

    public function parse_request() {
        global $wp;

        $query_vars = $this -> query_vars;

        // phpcs:disable WordPress.Security.NonceVerification.Recommended
        // Map query vars to their keys, or get them if endpoints are not supported.
        if(count($query_vars)){
            foreach ( $query_vars as $key => $var ) {
                $endpoint   = QueryHelper::get_endpoint_name($var);
                if ( isset( $_GET[ $endpoint ] ) ) {
                    $wp->query_vars[ $key ] = sanitize_text_field( wp_unslash( $_GET[ $endpoint ] ) );
                } /*elseif ( !empty($wp->query_vars) && isset( $wp->query_vars[ $endpoint ] ) ) {
                    $wp->query_vars[ $key ] = $wp->query_vars[ $endpoint ];
                }*/
                do_action('dealership/shortcode/parse_request/after', $endpoint, $key, $var);
            }
        }
    }

    public function get_query_vars(){
        return $this -> query_vars;
    }

    public function get_navigations(){
        $query_vars = QueryHelper::get_query_vars();

        if(!$query_vars){
            return array();
        }

        $menus  = array();
        foreach ($query_vars as $key => $var){
            if(isset($var['navigation']) && !$var['navigation']){
                continue;
            }

            $menus[$key]    = $var;
        }

        return $menus;
    }

    public function get_fields(){
        acf_form_head();
        wp_enqueue_script('dealership');
//        wp_enqueue_script('dealership', DLS_Function::get_my_url() . '/assets/js/dealership.js'
//            ,array('jquery', 'jquery-ui-core', 'jquery-ui-sortable', 'jquery-ui-datepicker'));
        wp_localize_script('dealership', 'dealership', array(
            'ajaxurl' => admin_url('admin-ajax.php')
        ));

        $post_id    = isset($_REQUEST['post'])?$_REQUEST['post']:'';
        $post_id    = isset($_REQUEST['id'])?$_REQUEST['id']:'';

        wp_localize_script('dealership', 'ap_product', array(
            'post_id'       => $post_id,
            'custom_fields' => array(
                'nonce' => wp_create_nonce('dealership_load_custom_fields')
            ),
        ));
//        wp_enqueue_style('dealership', DLS_Function::get_my_url().'/assets/css/style.css');
        $endpoint_key   = QueryHelper::get_current_endpoint_key();
        switch ($endpoint_key){
            default:
                $current_layout = $this -> get_layout();
                $endpoint   = QueryHelper::get_endpoint_layout();
                $_layout    = $current_layout == 'dealership'?$endpoint:$current_layout;

                $_layout    = str_replace(array('-','_'), ' ', $_layout);
                $_layout    = ucwords($_layout);
                $_layout    = str_replace(' ', '', $_layout);

                $class_name     = 'DealerShip\Frontend\EndPoints\\'.ucfirst($_layout).'EP';
                $obj    = call_user_func(array($class_name,'instance'));
                return $obj -> get_fields();
                break;
            case 'add-product':
            case 'edit-product':
                $class_name     = 'DealerShip\Frontend\EndPoints\ProductEP';
                $obj    = call_user_func(array($class_name,'instance'));
                return $obj -> get_fields();
                break;
        }
    }

    public function redirect_to_login_page(){
        global $post;
        $page_id  = (int)get_option('options_dealership_myaccount_page_id',0);
        // If not logged in and dealership page
        if(is_a( $post, 'WP_Post' ) &&
            has_shortcode($post -> post_content, $this -> get_shortcode_name())
            && !is_user_logged_in() && $page_id
            && is_page($page_id)){
            $login_page = get_field('dealership_login_page_id', 'option');
            if(!empty($login_page)){
                $permalink  = QueryHelper::get_main_permalink($login_page);
                if(!empty($permalink) && get_permalink()){

                    // Redirect to permalink without cache is 307
                    header('Location:'.$permalink, true, 307);
                    exit;
                }
            }
        }
    }

    public function render($attr)
    {

        $form_name  = isset($attr['form_name'])?$attr['form_name']:'';

        if(is_user_logged_in() && !$form_name) {
            $layout = 'my-account';

            if($layout) {
                $content    = $this -> render_template($layout);
                $notice = Notice::instance();
                $notice -> clean_notices();

                return $content;
            }
        }

        if(empty($form_name)){
            $notice = Notice::instance();
            if(!is_user_logged_in()){
                if(empty($_POST)) {
                    $message = get_field('dealership_login_message', 'option');
                    $message = !empty($message) ? $message : __('You are not authorised to view this resource. Please <a href="%s">login</a> first', 'dealership');
                    $message = sprintf($message, QueryHelper::get_main_permalink(get_option('options_dealership_login_page_id',
                        get_option('options_dealership_myaccount_page_id', 0))));
                    $notice->set_message($message, 'error');
                }

                $login_page = get_field('dealership_login_page_id', 'option');
                if(!empty($login_page)){
                    $permalink  = QueryHelper::get_main_permalink($login_page);
                    if(!empty($permalink)){

                        // Redirect to permalink without cache is 307
                        header('Location:'.$permalink, true, 307);
                        exit;
                    }
                }else{
                    $form_name  = 'login';
                }
            }
//            DLS_Template::load_my_layout('notice', true, false, array());
//
//            return false;
        }else{
            if(empty($_POST)) {
                $notice = Notice::instance();
                $notice->clean_notices();
            }
        }

        if($form_name == 'login'){
            if(is_user_logged_in()){
                $form_name  = 'profile';
            }
        }

        $this -> set_layout($form_name);

        return parent::render($attr);
    }

    public function enqueue_scripts(){
        global $post;
        if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dealership') ) {
            wp_enqueue_script( 'dealership-form-validation',
                plugins_url(DEALERSHIP.'/assets/js/validation.js',
                    DEALERSHIP), array('jquery'));
        }
    }

    public function register_scripts(){
        wp_register_style('dealership', DLS_Function::get_my_url().'/assets/css/style.css');
        wp_register_script('dealership', DLS_Function::get_my_url() . '/assets/js/dealership.js',
            array('jquery', 'jquery-ui-core', 'jquery-ui-sortable', 'jquery-ui-datepicker'));
        global $post;
        if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, $this -> get_shortcode_name()) ) {
            wp_enqueue_style('dealership');
        }
    }
}