<?php

namespace DealerShip;

use DealerShip\Interfaces\Base;
use DealerShip\Helpers\UserRoleHelper;

defined('DEALERSHIP') or exit();

class Setting extends Base{

    protected static $instance;

    public static function instance(){
        if(static::$instance){
            return static::$instance;
        }

        $instance   = new self();

        static::$instance   = $instance;
        return $instance;
    }

    public function hooks(){
        add_filter('advanced-product/settings/fields', array($this, 'register_settings'));
    }

    public function register_settings($fields){
        // Page Setup
        $my_fields = array(
            array(
                'key' => 'field_62ecc8cd5eb4d',
                'label' => __('Page setup', 'dealership'),
                'name' => 'dealership_page_setup',
                'type' => 'tab',
            ),
            array(
                'key' => 'field_62ecc947c25d6',
                'label' => __('My account page', 'dealership'),
                'name' => 'dealership_myaccount_page_id',
                'type' => 'post_object',
                'post_type'=> array('page')
            ),
            array(
                'key' => 'field_637f35db12a70',
                'label' => __('Dealers page', 'dealership'),
                'name' => 'dealership_dealer_page_id',
                'type' => 'post_object',
                'post_type'=> array('page')
            ),
            array(
                'key' => 'field_63a535763b1ad',
                'label' => __('Login page', 'dealership'),
                'name' => 'dealership_login_page_id',
                'type' => 'post_object',
                'post_type'=> array('page'),
                'allow_null'   => true
            ),
            array(
                'key' => 'field_64e42a8172949',
                'label' => __('Register page', 'dealership'),
                'name' => 'dealership_register_page_id',
                'type' => 'post_object',
                'post_type'=> array('page')
            ),
            array(
                'key' => 'field_64e42b715545e',
                'label' => __('Login Message', 'dealership'),
                'name' => 'dealership_login_message',
                'type' => 'textarea',
                'default_value'   => __('You are not authorised to view this resource. Please <a href="%s">login</a> first', 'dealership'),
            ),
            array(
                'key' => 'field_64e42d134cb91',
                'label' => __('Logged Message', 'dealership'),
                'name' => 'dealership_logged_message',
                'type' => 'textarea',
                'default_value'   => __('Welcome {display_name} to Dealership', 'dealership'),
            ),
        );

        $my_fields  = apply_filters('dealership/settings/fields/page-setup', $my_fields);

        // Appearance
        $roles  = array(
            ''  => __('- Default -', 'dealership')
        );

        $roles += UserRoleHelper::get_roles_choices_without_role_custom();

        $dls_roles  = UserRoleHelper::get_role_choices(array('choice_has_prefix' => true));
//        $dls_roles  = array();
        $dls_roles  = array_merge(array('' => __('- Select Role -', 'dealership')), $dls_roles);

        $appearance = array(
            array(
                'key'   => 'field_6437c05ed96b1',
                'label' => __('Appearance', 'dealership'),
                'name'  => 'dealership_appearance',
                'type'  => 'tab',
            ),
            array(
                'key'       => 'field_6437c1d5822b7',
                'label'     => __('Registration Default Role', 'dealership'),
                'name'      => 'dealership_register_role',
                'type'      => 'select',
                'choices'   => $dls_roles
            ),
            array(
                'key'       => 'field_6438bea7a3301',
                'label'     => __('Registration Dealer Default WP Role', 'dealership'),
                'name'      => 'dealership_register_dealer_wp_role',
                'type'      => 'select',
                'choices'   => $roles,
                'default_value'   => 'editor',
            ),
            array(
                'key'       => 'field_64ed50fdd81e5',
                'label'     => __('Registration Default Status', 'dealership'),
                'name'      => 'dealership_register_dealer_status',
                'type'      => 'select',
                'choices'   => array(
                    'pending'   => __('Pending', 'dealership'),
                    'approved'  => __('Approved', 'dealership')
                ),
            ),
        );

        $appearance = apply_filters('dealership/settings/fields/appearance', $appearance);

        $my_fields  = array_merge($my_fields, $appearance);

        $my_fields  = apply_filters('dealership/settings/fields', $my_fields);

        return array_merge($fields, $my_fields);
    }
}