<?php
namespace DealerShip\Interfaces;

use DealerShip\DLS_Template;
use DealerShip\Interfaces\Base;

defined('DEALERSHIP') or exit();

class ShortCode extends Template{

//    protected $layout               = '';
//    protected $layout_type          = '';
//    protected $default_layout       = '';
//    protected $default_layout_type  = '';

    protected static $instances = array();

    public function __construct()
    {
        parent::__construct();

        $this -> default_layout = $this -> get_shortcode_name();

        $this -> _load_shortcode();
    }

    public function get_shortcode_name(){
        $name   = $this -> get_name();
        $name   = preg_replace('/sc$/i', '', $name);

        return $name;
    }

    public static function instance(){
        $class_name = static::class;
        $name       = substr($class_name, strrpos($class_name, '\\')+1);
        $name       = strtolower($name);

        $instances  = &self::$instances;

        if(!isset($instances[$name])) {

            $instances[$name] = new $class_name();
        }
        return $instances[$name];
    }

    public function render($attr)
    {
        return $this -> render_template();
    }

    public function render_template($partial = false, $require_once = false){

        $partial    = $partial == false?$this -> get_layout():$partial;

        ob_start();
            DLS_Template::load_my_layout($partial, true, $require_once, array(
                'instance'  => $this
            ));
        $content    = ob_get_contents();
        ob_end_clean();

        return $content;
    }

    protected function _load_shortcode(){
        $shortcode  = $this -> get_shortcode_name();

        if(!shortcode_exists($shortcode)){
            // Register post type to wordpress
            add_shortcode($shortcode, array($this, 'render'));

            do_action('dealership/shortcode/registered', $shortcode, $this);
        }
    }

}