<?php

namespace DealerShip\Interfaces;

defined('DEALERSHIP') or exit();

class Session extends Base{

    /**
     * Session Data.
     *
     * @var array $_data Data array.
     */
    protected $_data = array();

    /**
     * Dirty when the session needs saving.
     *
     * @var bool $_dirty When something changes
     */
    protected $_dirty = false;

    protected static $instance = false;


    public static function instance(){
        if (session_id() === '') session_start();

        if(static::$instance){
            return static::$instance;
        }

        static::$instance = new self();

        return static::$instance;
    }

    /**
     * Get a session variable.
     *
     * @param string $key Key to get.
     * @param mixed  $default used if the session variable isn't set.
     * @return array|string value of session variable
     */
    public function get( $key, $default = null ) {
        $key = sanitize_key( $key );

        $dealer_session = isset($_SESSION['dealership'])?$_SESSION['dealership']:array();

        return isset( $dealer_session[ $key ] ) ? maybe_unserialize( $dealer_session[ $key ] ) : $default;
//        return isset( $this->_data[ $key ] ) ? maybe_unserialize( $this->_data[ $key ] ) : $default;
    }

    /**
     * Set a session variable.
     *
     * @param string $key Key to set.
     * @param mixed  $value Value to set.
     */
    public function set( $key, $value ) {
        if ( $value !== $this->get( $key ) ) {
            $this->_data[ sanitize_key( $key ) ] = maybe_serialize( $value );
//            $this->_dirty                        = true;
            $_SESSION['dealership'] = $this -> _data;
        }
    }
    /**
     * Magic unset method.
     *
     * @param mixed $key Key to unset.
     */
    public function __unset( $key ) {
        $dealer_session = isset($_SESSION['dealership'])?$_SESSION['dealership']:array();
        if ( isset( $dealer_session[ $key ] ) ) {
            unset( $dealer_session[ $key ] );
            $_SESSION['dealership'] = $dealer_session;
//            $this->_dirty = true;
        }
//        if ( isset( $this->_data[ $key ] ) ) {
//            unset( $this->_data[ $key ] );
//            $this->_dirty = true;
//        }
    }


    /**
     * Cleanup session data. Extended by child classes.
     */
    public function cleanup_sessions() {
        if(isset($_SESSION['dealership'])){
            unset($_SESSION['dealership']);
            $this -> _data  = array();
        }
    }
}