<?php

namespace DealerShip\Interfaces;

use DealerShip\DLS_Function;

defined('DEALERSHIP') or exit();

class PostType extends AdminTemplate {

    protected $default_layout       = 'base';
    protected $default_layout_type  = 'posttypes';

//    public static $label        = '';
//
//    protected $menu_slug;
////    public static $description  = '';
//
//    protected $parent_slug  = 'edit.php?post_type=ap_product';

    protected static $instances = array();

    public function __construct()
    {
        parent::__construct();

        $this -> default_layout_type    .= $this -> get_name();

//        if(empty(static::$label)){
//            static::$label  = ucfirst($this -> get_name());
//        }

        $this -> _load_post_type();
    }

    public static function instance(){
//        if(static::$instances){
//            return static::$instances;
//        }

        $class_name = static::class;
        $name       = substr($class_name, strrpos($class_name, '\\')+1);
        $name       = strtolower($name);

        $instances  = &self::$instances;

        if(!isset($instances[$name])) {

            $instances[$name] = new $class_name();

//        $instance -> hooks();

//            static::$instances[$name] = $instance;
        }
        return $instances[$name];
    }

    public function get_post_type_name(){
        $name   = $this -> get_name();

        return DEALERSHIP_PREFIX.'_'.$name;
    }

    public function my_post_type_exists(){
        $post_type  = $this -> get_post_type_name();
        if(\post_type_exists($post_type) && $this -> get_current_screen_post_type() == $post_type) {
            return true;
        }
        return false;
    }

    public function get_current_screen_post_type() {

        global $post, $typenow, $current_screen;

        if ($post && $post->post_type) return $post->post_type;

        elseif($typenow) return $typenow;

        elseif($current_screen && $current_screen->post_type) return $current_screen->post_type;

        elseif(isset($_REQUEST['post']) && \get_post_type($_REQUEST['post'])) return \get_post_type($_REQUEST['post']);
        elseif(isset($_REQUEST['post_type'])) return \sanitize_key($_REQUEST['post_type']);

        return null;

    }

    public function render()
    {
//        $tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'list';
//
//        $tab = $tab == 'add' ? 'edit' : $tab;

//        $this -> set_layout($tab);
//        $this -> set_layout_type('postypes/'.$this -> get_name());

        return $this -> render_template(true);
    }

    protected function _load_post_type(){
        $post_type  = $this->get_post_type_name();

        if(!\post_type_exists($post_type)){
            // Register post type to wordpress
            if(\method_exists($this, 'register')) {
                $args   = $this -> register();

                $args   = is_array($args)?$args:array();

                \register_post_type($post_type, $args);

                if($this -> my_post_type_exists()){
                    \do_action('dealership/post_type/'.$post_type.'/registered', $post_type, $this);
                }
                \do_action('dealership/post_type/registered', $post_type, $this);
            }
        }
    }

    protected function register(){
        return array();
    }
}