<?php

namespace DealerShip\Interfaces;

use DealerShip\DLS_Function;
use DealerShip\Helpers\QueryHelper;

defined('DEALERSHIP') or exit();

class EndPoint extends Base {

    protected static $instances = array();

    public static function instance(){

        $class_name = static::class;
        $name       = substr($class_name, strrpos($class_name, '\\')+1);
        $name       = strtolower($name);

        $instances  = &self::$instances;

        if(!isset($instances[$name])) {
            $instances[$name] = new $class_name();
        }
        return $instances[$name];
    }

    protected function get_redirect_permalink($endpoint = ''){
        return QueryHelper::get_endpoint_url(QueryHelper::get_current_endpoint(), $endpoint,
            QueryHelper::get_main_permalink());
    }

    protected function validate_fields($data){
        $validated  = true;
        $gfields    = $this -> get_fields();
        if(!empty($gfields)){
            $notice = Notice::instance();
            foreach ($gfields as $key => $group){
                $fields         = isset($group['fields'])?$group['fields']:array();
                $form_control   = isset($group['form_control'])?$group['form_control']:'fields';
                if(!empty($fields)){
                    foreach ($fields as $field){
                        $required   = isset($field['required'])?(bool)$field['required']:false;
                        if(!$required){
                            continue;
                        }
                        $form_value     = $form_control && isset($data[$form_control])?$data[$form_control]:$data[$field['name']];

                        if($form_value !== null){
                            if(is_array($form_value) && isset($form_value[$field['key']]) && empty($form_value[$field['key']])){
                                $validated = false;
                                $notice->enqueue_message(sprintf(__('Invalid field: %s', 'dealership'), $field['label']), 'error');
                            }elseif(empty($form_value)){
                                $validated = false;
                                $notice->enqueue_message(sprintf(__('Invalid field: %s', 'dealership'), $field['label']), 'error');
                            }
                        }
                    }
                }
            }
        }

        return $validated;
    }

    public function filter_fields($fields, $data){
        $output     = array();
//        $fields    = $this -> get_fields();

        if(!empty($fields)){
            foreach ($fields as $key => $group){
                $gfields         = isset($group['fields'])?$group['fields']:array();
                $form_control   = isset($group['form_control'])?$group['form_control']:'fields';
                if(!empty($gfields)){
                    foreach ($gfields as $field){
                        $form_value = $form_control && isset($data[$form_control])?$data[$form_control]:false;
//                        $form_value     = $form_control && isset($data[$form_control])?$data[$form_control]:$data[$field['name']];

                        if($form_value && is_array($form_value) && isset($form_value[$field['key']])){
                            if(!isset($output[$form_control])){
                                $output[$form_control]  = array();
                            }
                            $output[$form_control][$field['key']]   = $form_value[$field['key']];
                        }elseif(isset($data[$field['name']])){
                            $output[$field['name']] = $data[$field['name']];
                        }elseif(isset($data[$field['key']])){
                            $output[$field['key']] = $data[$field['key']];
                        }
                    }
                }
            }
        }

        return $output;
    }
}