<?php

namespace DealerShip\Interfaces;

use DealerShip\DLS_Function;

defined('DEALERSHIP') or exit();

class BaseHelper {
    protected $text_domain;

    protected static $cache    = array();
    protected static $instances = array();

    public function __construct()
    {
        $this -> theme          = \wp_get_theme();
        $this -> text_domain    = DLS_Function::get_my_text_domain();
    }

    public static function instance(){
//        if(static::$instances){
//            return static::$instances;
//        }

        $class_name = static::class;
        $name       = substr($class_name, strrpos($class_name, '\\')+1);
        $name       = strtolower($name);

        $instances  = &self::$instances;

        if(!isset($instances[$name])) {
            $instances[$name] = new $class_name();
        }
        return $instances[$name];
    }

    protected static function _get_store_id($args = array()){
        $_args      = \func_get_args();
        $store_id   = __METHOD__;
        $store_id  .= '::'.serialize($_args);

        return md5($store_id);
    }

}