<?php

namespace DealerShip\Helpers;

defined('DEALERSHIP') or die();

class ProductHelper{

    protected static $cache = array();

    public static function get_products($args = array()){

        $store_id   = __METHOD__;
        $store_id  .= '::'.serialize($args);
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        $user   = wp_get_current_user();

        // First lets set some arguments for the query:
        // Optionally, those could of course go directly into the query,
        // especially, if you have no others but post type.
        $default_args   = array(
            'post_type' => 'ap_product',
            'author'        =>  $user->ID,
            'posts_per_page' => 6
            // Several more arguments could go here. Last one without a comma.
        );
        $args = array_merge($default_args, $args);

        // Query the posts:
        $query = new \WP_Query($args);

        if(!empty($query) && !is_wp_error($query)){
            return static::$cache[$store_id]    = $query;
        }

        return false;

    }

    public static function get_total_by_user_id($user_id = 0, $args = array()){

        $user       = wp_get_current_user();
        $user_id    = $user_id?$user_id:$user -> ID;

        $store_id   = __METHOD__;
        $store_id  .= '::'.$user_id;
        $store_id  .= '::'.serialize($args);
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if(!$user_id){
            return 0;
        }
        $total = count_user_posts( $user_id , "ap_product" );
        return $total;

    }

}