<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\DLS_Template;
use DealerShip\DLS_Function;
use DealerShip\Helpers\Access;
use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\Notice;
use DealerShip\Interfaces\EndPoint;
use DealerShip\Helpers\QueryHelper;
use Advanced_Product\Helper\FieldHelper;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use um\core\Validation;

defined('DEALERSHIP') or exit();

class ProductEP extends EndPoint {

    public function hooks(){

        add_action( 'wp', array( $this, 'check_access'), 0 );

        add_action('wp_loaded', array($this, 'save_product'));
        add_action('wp_loaded', array($this, 'delete_product'));

        add_action('dealership/my-account/products/before_content', array($this, 'ap_archive_content'));
        add_action( 'wp_ajax_dealership_load_custom_fields', array( $this, 'load_custom_fields' ) );
        add_action( 'wp_ajax_nopriv_dealership_load_custom_fields', array( $this, 'load_custom_fields' ) );

        add_filter('acf/load_value', array($this, 'load_field_value'), 10, 3);

        // Filter media by post_author id
        add_filter( 'ajax_query_attachments_args', array($this, 'show_current_user_attachments'), 10, 1 );

    }

    public function show_current_user_attachments( $query = array() ) {
        $user_id        = get_current_user_id();
        $can_list_other = Access::authorise('_dls_can_list_other_image', false);
        if( $user_id && !$can_list_other) {
            $query['author'] = $user_id;
        }
        return $query;
    }

    public function ap_archive_content(){
        add_action('advanced-product/archive/compare/action', array($this, 'action_item'));
//        add_action('advanced-product/archive/after_content', array($this, 'action_item'));
    }

    public function check_access(){
        global $wp;
        $current_endpoint_key   = QueryHelper::get_current_endpoint_key();
        if($current_endpoint_key == 'add-product'){
            if(!$this -> can_add()){
                $permalink  = QueryHelper::get_main_permalink();

                $notice = Notice::instance();
                $notice -> set_message(__('You are not authorised to view this resource.', 'dealership'), 'error');

                wp_redirect($permalink);
                exit();
            }
        }
    }

    public function action_item(){
        DLS_Template::load_my_layout('my-account.product-action');
    }

    public function can_add(){
        return Access::authorise('_dls_can_add');
    }

    public function load_custom_fields(){
        check_admin_referer( 'dealership_load_custom_fields','nonce' );

        if(!class_exists('Advanced_Product\Helper\AP_Custom_Field_Helper')){
            echo '';
            wp_die();
        }

        $branch_slug    = isset($_REQUEST['branch_slug'])?$_REQUEST['branch_slug']:'';

        // Get branch by branch_slug
        $branches = get_terms ([
            'slug'     => $branch_slug,
            'taxonomy' => 'ap_branch',
            'hide_empty' => false,
        ] );

        if(!$branches || is_wp_error($branches)){
            echo '';
            wp_die();
        }

        $product_id = isset($_REQUEST['post_id'])?$_REQUEST['post_id']:0;
        $product    = get_post($product_id);
        $gfields    = array();
        $result     = '';

        // Get all group fields assigned to branch
        foreach ($branches as $branch) {
//                $gfields_assigned = \get_field('group_field_assigned', 'ap_branch_' . $branch->term_id);
            $gfields_assigned = \get_field('group_field_assigned', 'term_' . $branch->term_id);

            if(!empty($gfields_assigned)) {

                $gid = md5('property');
                $goptions = array(
                    'id' => 'acf_' . md5('product_property'),
                    'title' => __('Properties', 'dealership'),
                    'fields' => array(),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'ap_product',
                                'order_no' => 0,
                                'group_no' => 0,
                            ),
                        ),
                    ),
                    'options' => array(
                        'position' => 'normal',
                        'style' => 'default',
                        'layout' => 'default',
                        //                        'hide_on_screen' => array (
                        //                            /*'the_content',*/ 'custom_fields'
                        //                        ),
                        'hide_on_screen' => array(),
                    ),
                    'menu_order' => 0,
                );

                $order      = 'ASC';
                $order_by   = 'menu_order';

                foreach ($gfields_assigned as $i => $group_slug){
                    // Get group field info
                    $group  = get_term_by('slug', $group_slug, 'ap_group_field');

                    if(!empty($group) && !is_wp_error($group)){
                        $cfields = AP_Custom_Field_Helper::get_fields_by_group_field_slug($group_slug, array(
                            'field_order'     => $order,
                            'field_orderby'   => $order_by
                        ));

                        $fields = array();
                        if($cfields){
                            foreach($cfields as $cfield){
                                $fields[]   = FieldHelper::get_custom_field_option_by_id($cfield->ID);
                            }
                        }

                        if(!empty($fields)){
                            // Register fields for acf
                            $goptions['id'] = (!empty($group->slug) ? $group->slug : $gid);
                            $goptions['title'] = (!empty($group->name)) ? $group->name : __('Properties', 'dealership');
                            $goptions['menu_order'] = $i;

                            foreach( $fields as &$field ){
                                // apply filters
                                $field = apply_filters('acf/load_field_defaults', $field);

                                // set value
                                if(!isset($field['value']))
                                {
                                    $field['value'] = apply_filters('acf/load_value', false, $product_id, $field);
                                    $field['value'] = apply_filters('acf/format_value', $field['value'], $product_id, $field);
                                }
                            }

                            $goptions['fields'] = $fields;

                            register_field_group($goptions);

                            ob_start();
                                $args['postbox']                    = $goptions;
                                $args['postbox']['container_id']    = $goptions['id'];
                                DLS_Template::load_my_layout('my-account.product-postbox', true, false, $args);
                            $result .= ob_get_contents();
                            ob_end_clean();
                        }
                    }
                }
            }
        }

        echo wp_send_json_success($result);
        wp_die();
    }

    public function load_field_value($value, $post_id, $field){
        $endpoint_key   = QueryHelper::get_current_endpoint_key();
        $action         = isset($_REQUEST['action'])?$_REQUEST['action']:'';
        if($endpoint_key !== 'edit-product' && $action != 'dealership_load_custom_fields'){
            return $value;
        }

        $product_id = isset($_REQUEST['post_id'])?$_REQUEST['post_id']:0;
        $product_id = isset($_REQUEST['id'])?$_REQUEST['id']:0;

        $product    = null;
        if($product_id) {
            $product = get_post($product_id);
        }

        if($product_id && !is_wp_error($product) && isset($product->{$field['name']})) {
            $value = isset($product->{$field['name']}) ? $product->{$field['name']} : false;
        }else{
            if($fval = get_post_meta($product_id, $field['name'], true)) {
                $value = $fval;
            }
        }

        return $value;
    }

    public function get_fields(){
        return array(
            'dls_main'  => array(
                'id'            => 'main',
                'title'         => __('Main','dealership'),
                'form_control'  => false, /* Default is "fields"*/
                'fields'        => $this -> register_main_information_fields()
            ),
            'dls_properties'  => array(
                'id'        => 'properties',
                'title'    => __('Properties','dealership'),
                'fields'    => $this -> register_add_edit_fields()
            ),
        );
    }

    public function register_add_edit_fields(){

        if(!class_exists('Advanced_Product\Helper\FieldHelper')){
            return false;
        }
        $acf_fields  = FieldHelper::get_acf_fields_without_group_field(array(
            'orderby'   => array(
                'menu_order'    => 'ASC',
                '__protected'   => 'DESC'
            )
        ));
        return $acf_fields;
    }

    public function register_main_information_fields(){
        return array(
            array(
                'key'   => 'field_62fb06b988721',
                'name'  => 'post_title',
                'type'  => 'text',
                'required' => true,
                'label' => __('Title', 'dealership'),
            ),
            array(
                'key'   => 'field_62fb06c7ee592',
                'name'  => 'post_content',
                'type'  => 'wysiwyg',
                'required' => false,
                'label' => __('Description', 'dealership'),
            ),
            array(
                'key'   => 'field_62fb12e05afe2',
                'name'  => '_thumbnail_id',
                'type'  => 'image',
                'required' => false,
                'label' => __('Featured Image', 'dealership'),
            ),
        );
    }

    protected function can_save($is_new = true){
        $authorised = Access::authorise('_dls_can_edit') || Access::authorise('_dls_can_edit_private');
        if($is_new){
            $authorised = Access::authorise('_dls_can_add');
        }/*else{
            return Access::authorise('_dls_can_edit') || Access::authorise('_dls_can_edit_private');
        }*/

        $authorised = apply_filters('dealership/product/can_save', $authorised);

        return $authorised;
    }
    protected function can_delete(){
        $authorised =  Access::authorise('_dls_can_delete') || Access::authorise('_dls_can_delete_private');

        $authorised = apply_filters('dealership/product/can_delete', $authorised);

        return $authorised;
    }

    public function delete_product(){
        $notice = Notice::instance();

        if(!isset($_REQUEST['_wpnonce']) || !wp_verify_nonce($_REQUEST['_wpnonce'], 'dls_delete_product')) {
            return false;
        }

        $my_post_id = isset($_REQUEST['id'])?$_REQUEST['id']:0;

        if(!$my_post_id){
            $notice -> set_message(__('Post not found', 'dealership'), 'error');
            wp_redirect($this -> get_redirect_permalink('products'));
            exit;
        }

        $can_delete = $this -> can_delete();

        /**
         * Fires before a product is deleted, at the start of wp_delete_post().
         * @param int     $my_post_id Product ID.
         */
        $can_delete = apply_filters( 'dealership/product/pre_delete_product', $can_delete, $my_post_id);

        if(!$can_delete){
            $notice -> set_message(__('Delete not permitted', 'dealership'), 'error');
            $permalink  = $this -> get_redirect_permalink('products');
            $permalink   = apply_filters('dealership/product/can_delete/pre_redirect_permalink', $permalink);
            do_action('dealership/product/can_delete/before_redirect_permalink', $permalink);
            wp_redirect($permalink);
            exit;
        }

        /**
         * Fires before a product is deleted, at the start of wp_delete_post().
         * @param int     $my_post_id Product ID.
         */
        do_action( 'dealership/product/before_delete_product', $my_post_id );

        try {
            $result = wp_delete_post($my_post_id);
            $notice -> set_message(__('Post deleted', 'dealership'), 'success');

            /**
             * Fires immediately after a post is deleted from the database.
             * @param int     $my_post_id Product ID.
             */
            do_action( 'dealership/product/deleted_product', $my_post_id );
        }catch (\Exception $e){
            $notice -> set_message($e -> getMessage(), 'error');
            exit;
        }
        /**
         * Fires after a post is deleted, at the conclusion of wp_delete_post().
         * @param int     $my_post_id Product ID.
         */
        do_action( 'dealership/product/after_delete_product', $my_post_id );

        wp_redirect($this -> get_redirect_permalink('products'));
        exit;

    }

    public function save_product(){

        if(!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'dls_add_edit_product')) {
            return false;
        }

        $user   = wp_get_current_user();
        $notice = Notice::instance();

        $data   = $_POST;
        $is_new = isset($data['post_ID']) && $data['post_ID']?false:true;

        $can_save   = $this -> can_save($is_new);
        $can_save   = apply_filters('dealership/product/pre_save_product', $can_save, $data);

        if(!$can_save){
            if($is_new) {
                $notice->set_message(__('Add not permitted', 'dealership'), 'error');
            }else{
                $notice->set_message(__('Edit not permitted', 'dealership'), 'error');
            }
            $permalink   = $this -> get_redirect_permalink('products');
            $permalink   = apply_filters('dealership/product/can_save/pre_redirect_permalink', $permalink);
            do_action('dealership/product/can_save/before_redirect_permalink', $permalink);
            wp_redirect($permalink);
            exit;
        }

        $validData  = $this -> validate_fields($data);

        $permalink  = $this -> get_redirect_permalink();
        $permalink  = apply_filters('dealership/product/pre_redirect_permalink', $permalink);

        if(!$validData){
            do_action('dealership/product/valid_data/before_redirect_permalink', $permalink);
            wp_redirect($permalink);
            exit;
        }

        $acf_field_data = isset($data['fields'])?$data['fields']:array();
        unset($data['fields']);

        $my_post_id = isset($data['post_ID'])?$data['post_ID']:0;
        $product_stt = Access::authorise('_dls_product_status');
        if($product_stt){
            $data['post_status']    = ''.$product_stt.'';
        }else{
            $data['post_status']    = 'publish';
        }
        $data['post_type']      = 'ap_product';

        $data['post_author']    = $user -> ID;

        if($my_post_id){
            $data['ID'] = $my_post_id;
        }

        if($my_post_id){
            $my_post_id = wp_update_post($data);
        }else{
            $my_post_id = wp_insert_post($data);
        }

        if(!$my_post_id){
            $permalink  = $this -> get_redirect_permalink();
            $notice -> set_message(__('Error save post', 'dealership'), 'error');
            wp_redirect($permalink);
            exit;
        }

        // Save thumbnail for post
        if(isset($data['thumbnail_id']) && !empty($data['thumbnail_id'])){
            set_post_thumbnail($my_post_id, $data['thumbnail_id']);
        }

        $acf_field_data = apply_filters('dealership/product/pre_custom_field_data', $acf_field_data, $my_post_id);

        // Update field value
        if(count($acf_field_data)){

            do_action( 'dealership/product/before_update_field', $my_post_id );

            foreach ($acf_field_data as $key => $field_value){
                \update_field($key, $field_value, $my_post_id);
            }
        }

        $notice -> set_message(__('Product saved', 'dealership'), 'success');

        wp_redirect($this -> get_redirect_permalink('products'));
        exit;

    }

    protected function get_redirect_permalink($endpoint = ''){

        if(empty($endpoint)){
            if(isset($_POST['post_ID']) && $_POST['post_ID']){
                $endpoint   = 'edit-product';
            }else{
                $endpoint   = 'add-product';
            }
        }

        $permalink  = parent::get_redirect_permalink($endpoint);

        return $permalink;
    }

}