<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\Helpers\QueryHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\EndPoint;

defined('DEALERSHIP') or exit();

class LogoutEP extends EndPoint {

    public function hooks(){
        add_action('wp_loaded', array($this, 'logout'));
    }

    public function logout(){
        if(!isset($_GET['_wpnonce']) || !wp_verify_nonce($_GET['_wpnonce'], 'dls_customer-logout')) {
            return false;
        }
        $permalink  = QueryHelper::get_main_permalink();

        wp_logout();

        // Redirect to permalink without cache is 307
        header('Location:'.$permalink, true, 307);
        exit;
    }

}