<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\DLS_Template;
use DealerShip\Helpers\QueryHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\EndPoint;
use DealerShip\Interfaces\Notice;
use DealerShip\Interfaces\Session;

defined('DEALERSHIP') or exit();

class LoginEP extends EndPoint {

    public function hooks(){
        add_action('wp_loaded', array($this, 'login'));
//        add_action('template_redirect', array($this, 'login'));

        /**
         * Check user status login
         * If user status is pending, reject login
         */
        add_filter( 'authenticate', array($this, 'wp_form_errors_hook_logincheck'), 50, 3 );
    }

    public function wp_form_errors_hook_logincheck( $user, $username, $password ){

        if ( isset( $user->ID ) ) {

            $status = get_user_meta($user -> ID, 'dls_account_status', true);

            switch( $status ) {
                case 'pending':
                    return new \WP_Error( $status, __( 'Your account has not been approved yet.', 'dealership' ) );
                    break;
            }

        }

        return $user;
    }

    public function get_fields(){
        return $this -> register_fields();
    }

    public function register_fields(){
        return array(
            array(
                'key'   => 'field_62e211cd5df97',
                'name'  => 'username',
                'type'  => 'text',
//                'required' => true,
                'label' => __('Username or Email Address', 'dealership'),
            ),
            array(
                'key'   => 'field_62e211da595aa',
                'name'  => 'password',
                'type'  => 'password',
//                'required' => true,
                'label' => __('Password', 'dealership'),
            )/*,
            array(
                'key'   => 'field_62e214fd5d338',
                'name'  => 'rememberme',
                'type'  => 'checkbox',
//                'required' => true,
                'choices'   => array(
                    'Remember Me'
                ),
//                'label' => __('Remember Me', 'dealership'),
            )*/
        );
    }

    public function login(){

        static $valid_nonce = null;

        if ( null === $valid_nonce ) {
            // The global form-login.php template used `_wpnonce` in template versions < 3.3.0.
            $nonce_value = isset($_REQUEST['dealership-login-nonce'])?$_REQUEST['dealership-login-nonce']:null;
            $valid_nonce = wp_verify_nonce( $nonce_value, 'dls_login_form' );
        }

        if(isset( $_POST['login'], $_POST['username'], $_POST['password'] ) &&  $valid_nonce){
            try{
                $creds = array(
                    'user_login'    => trim( wp_unslash( $_POST['username'] ) ), // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                    'user_password' => $_POST['password'], // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.MissingUnslash
                    'remember'      => isset( $_POST['rememberme'] ), // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                );

                $validation_error = new \WP_Error();
                $validation_error = apply_filters( 'dealership_process_login_errors', $validation_error, $creds['user_login'], $creds['user_password'] );

                if ( $validation_error->get_error_code() ) {
                    $notice = Notice::instance();
                    $notice -> clean_notices();
                    $notice -> set_message($validation_error -> get_error_message(), 'error');
                    add_action('dealership_before_form', array($this, 'render_message'));
                    return false;
                }


                $user = wp_signon( apply_filters( 'dealership_login_credentials', $creds ), is_ssl() );


                if ( is_wp_error( $user ) ) {
                    $notice = Notice::instance();
                    $notice -> clean_notices();
                    $notice -> set_message($user -> get_error_message(), 'error');
                    return false;
                } else {

                    if ( ! empty( $_POST['redirect'] ) ) {
                        $permalink = wp_unslash( $_POST['redirect'] );
                    } else {
                        $permalink = QueryHelper::get_main_permalink();
                    }

                    $permalink = remove_query_arg( array( 'password-reset' ), $permalink );

                    wp_set_current_user($user->ID);
                    wp_set_auth_cookie($user->ID, $creds['remember'] );

                    // Redirect to permalink without cache is 307
                    header('Location:'.$permalink, true, 307);

                    exit;
                }

            }catch (\Exception $exception){
                $notice = Notice::instance();
                $notice -> clean_notices();
                $notice -> set_message($exception -> get_error_message(), 'error');
                do_action('dealership_login_failed');
                return false;
            }
        }
    }

    public function render_message($args){
        DLS_Template::load_my_layout('notice', true, false, $args);
    }

}