<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\Helpers\QueryHelper;
use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\EndPoint;
use DealerShip\Interfaces\Notice;

defined('DEALERSHIP') or exit();

class EditAccountEP extends EndPoint {

    public function hooks(){
        add_action('wp_loaded', array($this, 'edit'));
    }

    public function get_fields(){
        return $this -> register_fields();
    }

    public function register_fields(){
        return array(
            array(
                'key'   => 'field_62eb4e372eef4',
                'name'  => 'first_name',
                'type'  => 'text',
                'label' => __('First Name', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e484d700',
                'name'  => 'last_name',
                'type'  => 'text',
                'label' => __('Last Name', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e5786e14',
                'name'  => 'display_name',
                'type'  => 'text',
                'label' => __('Display Name', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e6cd7307',
                'name'  => 'user_email',
                'type'  => 'email',
                'required' => true,
                'label' => __('Email', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e5e5e941',
                'name'  => 'password_current',
                'type'  => 'password',
                'label' => __('Current password (leave blank to leave unchanged)', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e66f3ade',
                'name'  => 'pass1',
                'type'  => 'password',
                'label' => __('New password (leave blank to leave unchanged)', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb4e66f3ade',
                'name'  => 'pass2',
                'type'  => 'password',
                'label' => __('Confirm password', 'dealership'),
            ),
            array(
                'key'   => 'field_651264e6b3ad1',
                'name'  => '_dls_map_location',
                'type'  => 'text',
                'label' => __('Map Location', 'dealership'),
            ),
        );
    }

    public function edit(){
        if(!is_user_logged_in() || !isset($_POST['_wpnonce']) ||
            !wp_verify_nonce($_POST['_wpnonce'], 'dls_edit_user_form')) {
            return false;
        }
        $args   = $_POST;

        $query_vars = QueryHelper::get_query_vars();
        $endpoint   = isset($query_vars['edit-account'])?$query_vars['edit-account']['slug']:'dls_edit-account';

        $permalink  = QueryHelper::get_endpoint_url($endpoint, '', QueryHelper::get_main_permalink());

        $current_user   = \wp_get_current_user();
        $user           = new \stdClass();

        $user -> ID = get_current_user_id();

        $pass1          = '';
        $pass2          = '';
        $pass_current   = '';

        if ( isset( $_POST['pass1'] ) ) {
            $pass1 = trim( $_POST['pass1'] );
        }
        if ( isset( $_POST['pass2'] ) ) {
            $pass2 = trim( $_POST['pass2'] );
        }
        if ( isset( $_POST['password_current'] ) ) {
            $pass_current = trim( $_POST['password_current'] );
        }
        if ( isset( $_POST['first_name'] ) ) {
            $user -> first_name = trim( $_POST['first_name'] );
        }
        if ( isset( $_POST['last_name'] ) ) {
            $user -> last_name = trim( $_POST['last_name'] );
        }
        if ( isset( $_POST['display_name'] ) ) {
            $user -> display_name = trim( $_POST['display_name'] );
        }

        if(!empty($pass1) || !empty($pass2) || !empty($pass_current)){
            if(empty($pass1) || empty($pass2) || empty($pass_current)){
                $this -> set_message(__('Please fill out all password fields.', 'dealership'), 'error');
                wp_redirect($permalink);
                exit;
            }

            // Checking the password has been typed twice the same.
            if(!wp_check_password($pass_current, $current_user ->user_pass) || $pass1 != $pass2){
                $this -> set_message(__('New passwords do not match.', 'dealership'), 'error');
                wp_redirect($permalink);
                exit;
            }

            $user->user_pass = $pass1;
        }

        $notice = Notice::instance();

        // Can update user
        $can_save = apply_filters('dealership/account/pre_update_user', true);

        if(!$can_save){
            $notice -> set_message(__('Edit not permitted.', 'dealership'), 'error');

            $permalink  = $this -> get_redirect_permalink();
            $permalink  = apply_filters('dealership/product/can_save/pre_redirect_permalink', $permalink);

            do_action('dealership/account/can_save/before_redirect_permalink', $permalink);

            wp_redirect($permalink);

            exit;
        }

        // Update user
        wp_update_user($user);

        // Update user meta
        if(isset($_POST['_dls_map_location']) && !empty($_POST['_dls_map_location']) && $user -> ID){
            update_user_meta($user -> ID, '_dls_map_location', $_POST['_dls_map_location']);
        }

        $notice -> set_message(__('Account details changed successfully.', 'dealership'), 'success');

        do_action('dealership/account/after_update_user', $user);

        wp_redirect($permalink);
        exit;

    }

}