<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\DLS_Template;
use DealerShip\DLS_Function;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\Notice;
use DealerShip\Interfaces\EndPoint;
use DealerShip\Helpers\QueryHelper;
use Advanced_Product\Helper\FieldHelper;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use um\core\Validation;

defined('DEALERSHIP') or exit();

class DealersEP extends EndPoint {

    public function hooks(){
        if(!is_admin()) {
            add_filter('dealership/queryhelper/query_vars', array($this, 'init_query_vars'));
            add_action('dealership/shortcode/add_endpoint/after', array($this, 'add_endpoints'), 10, 4);
//            add_filter('dealership/shortcode/add_query_var/after', array($this, 'add_query_vars'), 10, 4);
//            add_action('dealership/shortcode/parse_request/after', array($this, 'parse_query'), 10, 3);
        }
    }

    public function init_query_vars($query_vars){
        if($authors = get_users()){
            foreach ($authors as $author){
                $query_vars[$author -> user_login]   = array(
                    'slug'      => $author -> user_login,
                    'title'     => $author -> display_name,
                    'parent'    => 'dealers',
                    'level'     => 1,
                    'navigation'=> false
                );
            }
        }

        return $query_vars;
    }

    // Add username to url's endpoint
    public function add_endpoints($endpoint, $name, $value, $mask){
        if($name == 'dealers' && ($authors = get_users())){
             foreach ($authors as $author){
                 \add_rewrite_endpoint( $author -> user_login, $mask );
             }
        }
    }

    // Add username to query var
    public function add_query_vars($vars, $endpoint, $name, $value){
        if($name == 'dealers' && ($authors = get_users())){
             foreach ($authors as $author){
                 $vars[]    = $author -> user_login;
             }
        }

        return $vars;
    }

    // Add username to query var
    public function parse_query($endpoint, $name, $value){
        global $wp;

        if(isset($wp -> query_vars['pagename'])){
            $keys   = array_keys($wp -> query_vars);

            if(count($keys) > 1){
                $next   = array_slice($keys, array_search('pagename', $keys) + 1,1);

                if(!empty($next)) {
                    $wp->query_vars['author'] = $next[0];
                }
            }
        }
    }

}