<?php

namespace DealerShip;

defined('DEALERSHIP') or exit();

class DLS_Function{
    protected static $cache         = array();

    public static function get_my_data(){
        $storeId    = md5(__METHOD__);

        if(isset(self::$cache[$storeId])){
            return self::$cache[$storeId];
        }

        $file   = DEALERSHIP_PATH.'/'.DEALERSHIP.'.php';

        if(!file_exists($file)){
            return false;
        }
        if( !function_exists('get_plugin_data') ){
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }

        if($plugin = \get_plugin_data( $file, true, true )){

            $other_data = get_file_data( $file,
                array(
                    'Forum' => 'Forum',
                    'Ticket' => 'Ticket',
                    'FanPage' => 'FanPage',
                    'Twitter' => 'Twitter',
                    'Google' => 'Google+'
                ),
                'plugin' );
            $plugin = array_merge($plugin, $other_data);

            self::$cache[$storeId]  = $plugin;
            return $plugin;
        }
        return false;
    }

    public static function get_my_url(){
        return untrailingslashit(plugins_url().'/'.DEALERSHIP);
    }

    public static function get_my_version(){
        $plugin = self::get_my_data();

        return $plugin['Version'];
    }

    public static function get_my_text_domain(){
        $plugin = self::get_my_data();

        $text_domain    = ($plugin && isset($plugin['TextDomain']))?$plugin['TextDomain']:'advanced-product';
        return $text_domain;
    }

    /**
     * @param $url
     */
    public static function js_redirect( $url ) {
        if ( headers_sent() || empty( $url ) ) {
            //for blank redirects
            if ( '' == $url ) {
                $url = set_url_scheme( '//' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"] );
            }

            register_shutdown_function( function( $url ) {
                echo '<script data-cfasync="false" type="text/javascript">window.location = "' . esc_js( $url ) . '"</script>';
            }, $url );

            if ( 1 < ob_get_level() ) {
                while ( ob_get_level() > 1 ) {
                    ob_end_clean();
                }
            } ?>
            <script data-cfasync='false' type="text/javascript">
                window.location = '<?php echo esc_js( $url ); ?>';
            </script>
            <?php exit;
        } else {
            wp_redirect( $url );
        }
        exit;
    }
}