<?php

defined('DEALERSHIP') or exit();

global $post_id;
$fields = $this -> register_fields();
?>
<div class="field_form">
    <?php
    if( is_array($fields) ){
        $role_id    = isset($_REQUEST['id'])?$_REQUEST['id']:'';
        $options    = !empty($role_id)?\get_option(DEALERSHIP_PREFIX.'_role_'.$role_id.'_meta'):array();

        foreach( $fields as $field ){

        // if they didn't select a type, skip this field
        if( !$field || !$field['type'] || $field['type'] == 'null' )
        {
            continue;
        }

        // apply filters
        $field = apply_filters('acf/load_field_defaults', $field);

        // set value
        if( !isset($field['value']))
        {
            $field['value'] = isset($options[$field['name']])?$options[$field['name']]:null;

            if($field['value'] == null && isset($field['default']) && !isset($options[$field['name']])){
                $field['value'] = $field['default'];
            }

            // Set field is true when role is administrator
            if($field['value'] == null && $role_id == 'administrator'){
                $field['value'] = 1;
            }
        }

        // required
        $required_class = "";
        $required_label = "";

        if(!empty($field) && isset( $field['required']) && $field['required'] )
        {
            $required_class = ' required';
            $required_label = ' <span class="required">*</span>';
        }

        echo '<div id="acf-' . $field['name'] . '" class="field field_type-' . $field['type'] . ' field_key-' . $field['key'] . $required_class . '" data-field_name="' . $field['name'] . '" data-field_key="' . $field['key'] . '" data-field_type="' . $field['type'] . '">';

        echo '<p class="label">';
        echo '<label for="' . $field['id'] . '">' . $field['label'] . $required_label . '</label>';
        echo $field['instructions'];
        echo '</p>';

        $field['name'] = $this -> get_metabox_name().'[' . $field['name'] . ']';
        do_action('acf/create_field', $field, $post_id);

        echo '</div>';

    } }
    ?>
</div>
