<?php

namespace DealerShip\Admin\PostTypes;

use DealerShip\Interfaces\PostType;

defined('DEALERSHIP') or exit();

class UserForm extends PostType {

    public function hooks(){
        add_action( 'admin_init', array( $this, 'register_fields' ) );
    }

    public function register(){
        /**
         * Post types
         */
        $singular  = __( 'User Form', 'dealership' );
        $plural    = __( 'User Forms', 'dealership' );

        $args = array(
            'description'         => __( 'This is where you can create and manage products.', 'dealership' ),
            'labels' => array(
//                    'name' 					=> $plural,
                'name' 					=> __( 'User Forms', 'dealership' ),
                'singular_name' 		=> $singular,
                'menu_name'             => __( 'User Forms', 'dealership' ),
                'all_items'             => sprintf( __( '%s', 'dealership' ), $plural ),
                'add_new' 				=> __( 'Add New', 'dealership' ),
                'add_new_item' 			=> sprintf( __( 'Add %s', 'dealership' ), $singular ),
                'edit' 					=> __( 'Edit', 'dealership' ),
                'edit_item' 			=> sprintf( __( 'Edit %s', 'dealership' ), $singular ),
                'new_item' 				=> sprintf( __( 'New %s', 'dealership' ), $singular ),
                'view' 					=> sprintf( __( 'View %s', 'dealership' ), $singular ),
                'view_item' 			=> sprintf( __( 'View %s', 'dealership' ), $singular ),
                'search_items' 			=> sprintf( __( 'Search %s', 'dealership' ), $plural ),
                'not_found' 			=> sprintf( __( 'No %s found', 'dealership' ), $plural ),
                'not_found_in_trash' 	=> sprintf( __( 'No %s found in trash', 'dealership' ), $plural ),
                'parent' 				=> sprintf( __( 'Parent %s', 'dealership' ), $singular )
            ),
            'supports'            => array( 'title'/*, 'editor', 'thumbnail','excerpt', 'custom-fields','comments'*/ ),
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
//            'show_in_menu'        => true,
//            'show_in_menu'        => 'edit.php?post_type=ap_product',
            'show_in_menu'        => 'edit.php?post_type='.$this -> get_post_type_name(),
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 21,
//                'menu_icon'           => AP_Functions::get_my_url() . '/assets/images/icon.svg',
            'menu_icon'           => 'dashicons-store',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'rewrite'			  => array( 'slug' => DEALERSHIP_PREFIX.'-'.$this -> get_name())
        );
        return $args;
    }

    public function register_fields()
    {
        if (!function_exists("register_field_group")) {
            return;
        }

        register_field_group(
            array(
                'id' => 'acf_'.md5($this -> get_post_type_name().'_properties'),
                'title' => __( 'Properties', 'dealership' ),
                'fields' => array(
                    array(
                        'key'   => 'field_52816a1633584',
                        'type'  => 'flexible_content',
                        'name'  => 'dls_user_form_field',
                        'label' => __('Field Form', 'dealership'),
                        'layouts' =>
                                                    array (
                                'label' => __( 'Number field', 'dealership' ),
                                'name' => 'ap_number_field',
                                'display' => 'table',
                                'min' => '',
                                'max' => '',
                                'sub_fields' => array (
                                    array (
                                        'key' => 'field_52816abf33585',
                                        'label' => __( 'Name', 'dealership' ),
                                        'name' => 'ap_name',
                                        'type' => 'text',
                                        'column_width' => 35,
                                        'default_value' => '',
                                        'placeholder' => __( 'E.g. "Horsepower"', 'dealership' ),
                                        'prepend' => '',
                                        'append' => '',
                                        'formatting' => 'none',
                                        'maxlength' => '',
                                    ),
                                )
                                                    )
//                        'layouts' => array(
//                            array(
//                                'key'   => 'field_sub_',
//                                'type'  => 'text',
//                                'name'  => 'dls_sub_field',
//                                'label' => __('Field Type')
//                            )
//                        ),
                    )
                ),
                'location' => array (
                    array (
                        array (
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => $this -> get_post_type_name(),
                            'order_no' => 0,
                            'group_no' => 0,
                        ),
                    ),
                ),
                'options' => array (
                    'position' => 'normal',
                    'style' => 'default',
                    'layout' => 'default',
//                        'hide_on_screen' => array (
//                            /*'the_content',*/ 'custom_fields'
//                        ),
                    'hide_on_screen' => array(),
                ),
                'menu_order' => 0,
            )
        );
    }

}
