<?php

namespace DealerShip\Admin\Pages;

defined('DEALERSHIP') or exit();

use DealerShip\Admin\Tables\UserRolesTable;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\Page;
use DealerShip\DLS_Function;

class UserRoles extends Page {

    public static $label    = 'User Roles';

    public function hooks(){
        add_action('dealership/page/'.$this -> get_page_name().'/registered', array($this, 'role_actions'), 10, 2);
    }

    public function register()
    {
        $register   = parent::register();

        $register['position']   = 11;

        return $register;
    }

    public function get_items(){
        $ListTable  = new UserRolesTable( array(
            'parent_slug'   => __( $this -> parent_slug, 'dealership' ),
            'menu_slug'     => $this -> get_property('menu_slug'),
            'singular'      => __( 'Role', 'dealership' ),
            'plural'        => __( 'Roles', 'dealership' ),
            'ajax'          => false
        ));

        $per_page   = 20;
        $paged      = $ListTable->get_pagenum();

        $ListTable->set_bulk_actions( array(
            'delete' => __( 'Delete', 'dealership' )
        ) );

        $ListTable->set_columns( array(
            'title'         => __( 'Role Title', 'dealership' ),
            'roleid'        => __( 'Role ID', 'dealership' ),
            'users'         => __( 'No.of Members', 'dealership' ),
            'core'          => __( 'Dealership Custom Role', 'dealership' ),
            'admin_access'  => __( 'WP-Admin Access', 'dealership' ),
            'priority'      => __( 'Priority', 'dealership' ),
        ) );

        $ListTable->set_sortable_columns( array(
            'title' => 'title'
        ) );

        $users_count = \count_users();
        $roles = array();
        $role_keys = \get_option( 'dls_roles', array() );

        if ( $role_keys ) {
            foreach ( $role_keys as $role_key ) {
                $role_meta = \get_option( "dls_role_{$role_key}_meta" );
                if ( $role_meta ) {

                    $roles[  DEALERSHIP_PREFIX.'_'.$role_key ] = array(
                        'key'   => $role_key,
                        'users' => ! empty( $users_count['avail_roles'][  DEALERSHIP_PREFIX.'_'.$role_key ] ) ? $users_count['avail_roles'][  DEALERSHIP_PREFIX.'_'.$role_key ] : 0
                    );
                    $roles[  DEALERSHIP_PREFIX.'_'.$role_key ] = array_merge( $roles[  DEALERSHIP_PREFIX.'_'.$role_key ], $role_meta );
                }
            }
        }


        global $wp_roles;

        foreach ( $wp_roles->roles as $roleID => $role_data ) {
            if ( in_array( $roleID, array_keys( $roles ) ) ) {
                continue;
            }

            $roles[$roleID ] = array(
                'key'   => $roleID,
                'users' => ! empty( $users_count['avail_roles'][ $roleID ] ) ? $users_count['avail_roles'][ $roleID ] : 0,
                'name'  => $role_data['name']
            );

            $role_meta = \get_option( "dls_role_{$roleID}_meta" );
            if ( $role_meta ) {
                $roles[ $roleID ] = array_merge( $roles[ $roleID ], $role_meta );
            }
        }
//        var_dump($roles); die(__FILE__);

        $order_by = 'name';
        $order    = ( isset( $_GET['order'] ) && 'asc' === strtolower( sanitize_key( $_GET['order'] ) ) ) ? 'ASC' : 'DESC';

        switch( strtolower( $order ) ) {
            case 'asc':
                uasort( $roles, function( $a, $b ) {
                    return strnatcmp( $a['name'], $b['name'] );
                } );
                break;
            case 'desc':
                uasort( $roles, function( $a, $b ) {
                    return strnatcmp( $a['name'], $b['name'] ) * -1;
                } );
                break;
        }

        $ListTable->prepare_items();
        $ListTable->items = array_slice( $roles, ( $paged - 1 ) * $per_page, $per_page );
        $ListTable->dls_set_pagination_args( array( 'total_items' => count( $roles ), 'per_page' => $per_page ) );

        return $ListTable;
    }

    public function role_actions($menu_slug, $page_obj){
        if($this -> my_page_exists() && isset( $_GET['action'] )){
            if ( isset( $_REQUEST['_wp_http_referer'] ) ) {
                $redirect = remove_query_arg( array( '_wp_http_referer' ), wp_unslash( $_REQUEST['_wp_http_referer'] ) );
            } else {
                $redirect = get_admin_url() . 'admin.php?page='.$this -> get_page_name();
            }

            switch ( sanitize_key( $_GET['action'] ) ) {
                /* delete action */
                case 'delete':
                {
                    // uses sanitize_title instead of sanitize_key for backward compatibility based on #906 pull-request (https://github.com/ultimatemember/ultimatemember/pull/906)
                    // roles e.g. "潜水艦subs" with both latin + not-UTB-8 symbols had invalid role ID
                    $role_keys = array();
                    if (isset($_REQUEST['id'])) {
                        check_admin_referer('dls_role_delete' . sanitize_title($_REQUEST['id']) . get_current_user_id());
                        $role_keys = (array)sanitize_title($_REQUEST['id']);
                    } elseif (isset($_REQUEST['item'])) {
                        check_admin_referer('bulk-' . sanitize_key(__('Roles', 'dealership')));
                        $role_keys = array_map('sanitize_title', $_REQUEST['item']);
                    }

                    if (!count($role_keys)) {
                        DLS_Function::js_redirect($redirect);
                    }

                    $dls_roles = get_option(DEALERSHIP_PREFIX.'_roles', array());

                    $um_custom_roles = array();
                    foreach ($role_keys as $k => $role_key) {
                        $role_meta = get_option(DEALERSHIP_PREFIX."_role_{$role_key}_meta");

                        if (empty($role_meta['_'.DEALERSHIP_PREFIX.'_is_custom'])) {
                            continue;
                        }

                        delete_option(DEALERSHIP_PREFIX."_role_{$role_key}_meta");
                        $dls_roles = array_diff($dls_roles, array($role_key));

                        $roleID = DEALERSHIP_PREFIX.'_' . $role_key;
                        $um_custom_roles[] = $roleID;

                        //check if role exist before removing it
                        if (get_role($roleID)) {
                            remove_role($roleID);
                        }
                    }

                    //set for users with deleted roles role "Subscriber"
                    $args = array(
                        'blog_id' => get_current_blog_id(),
                        'role__in' => $um_custom_roles,
                        'number' => -1,
                        'count_total' => false,
                        'fields' => 'ids',
                    );
                    $users_to_subscriber = get_users($args);
                    if (!empty($users_to_subscriber)) {
                        foreach ($users_to_subscriber as $user_id) {
                            $object_user = get_userdata($user_id);

                            if (!empty($object_user)) {
                                foreach ($um_custom_roles as $roleID) {
                                    $object_user->remove_role($roleID);
                                }
                            }

                            //update user role if it's empty
                            if (empty($object_user->roles)) {
                                wp_update_user(
                                    array(
                                        'ID' => $user_id,
                                        'role' => 'subscriber',
                                    )
                                );
                            }
                        }
                    }

                    update_option(DEALERSHIP_PREFIX.'_roles', $dls_roles);

                    DLS_Function::js_redirect(add_query_arg('msg', 'd', $redirect));
                    break;
                }
            }
        }
    }

    public function render()
    {
        \do_action('dls_user_roles_add_meta_boxes', 'dls_role_meta');
        return parent::render();
    }
}
