<?php

namespace DealerShip;

use DealerShip\Helpers\Access;
use DealerShip\Admin\AdminMenus;
use DealerShip\Admin\AdminWPUser;
use DealerShip\Admin\AdminSetting;
use DealerShip\Admin\AdminMetaBoxes;
use DealerShip\Admin\AdminPostTypes;
use DealerShip\Interfaces\AdminTemplate;

defined('DEALERSHIP') or die();

class Admin extends AdminTemplate {

    private $access_msg    = array();

    public function __construct()
    {
        parent::__construct();

        new AdminMenus();
        new AdminPostTypes();
        new AdminMetaBoxes();
        new AdminWPUser();

        $this -> access_msg = array(
            'access'    => 'ac',
            'add'       => 'a',
            'edit'      => 'e',
            'delete'    => 'd',
        );

        $this -> check_access();
    }

    public function hooks(){
        $key    = DEALERSHIP_PREFIX.'_access_msg';
        if(isset($_GET[$key]) && $_GET[$key] == 'u'){
            add_action( 'admin_notices', array($this, 'admin_notice') );
        }
    }

    public function admin_notice(){
        $this -> set_layout('admin_notice');
        return $this -> render_template();
    }

    /* Check permission of advanced product */
    protected function check_access(){

        global $pagenow;

        $action     = isset($_REQUEST['action'])?$_REQUEST['action']:'';
        $_post_type = $this -> get_current_screen_post_type();

        if($_post_type != 'ap_product'){
            return;
        }

        if($pagenow == 'post-new.php') {

            if ( !function_exists('wp_get_current_user') ) {
                include(ABSPATH . "wp-includes/pluggable.php");
            }
            // Can add new advanced product
            $this -> permission('add');
        }elseif($pagenow == 'post.php'){
            $per_action = '';

            switch($action){
                case 'edit':
                case 'editpost':
                    $per_action = 'edit';
                    break;
                case 'delete':
                    $per_action = 'delete';
                    break;
                case 'elementor':
                    $per_action = 'edit';
                    break;
            }
            if(!empty($per_action)){
                $this->permission($per_action);
            }
        }
    }

    /* Permission */
    protected function permission($action){

        $paction    = '_dls_can_'.$action;
        $paction   .= in_array($action, array('edit', 'delete'))?'_private':'';

        $access     = Access::authorise($paction);
        $can_access = Access::authorise('_dls_can_access');

        $url    = \admin_url();

        if($can_access != null && $can_access){
            $_post_url  = 'edit.php?post_type=ap_product';

//            $_post_url  = (isset($_REQUEST['post_status']))?$_post_url.'&post_status'.$_REQUEST['post_status']:$_post_url;
            $_post_url  = ($action == 'delete')?$_post_url.'&post_status=trash':$_post_url;

            $url        = \admin_url($_post_url);
        }

        if(!$access){
            $redirect   = \add_query_arg( array(DEALERSHIP_PREFIX.'_access_msg' => 'u',
                'msg' => $this -> access_msg[$action]),
                $url);
            \wp_redirect($redirect);
            exit();
        }
    }

    protected function get_template($layout = ''){

        if(empty($layout)){
            return false;
        }

        $layout = stripos($layout, '.php') !== false?$layout:$layout.'.php';

        $base_path  = DEALERSHIP_ADMIN_TEMPLATE_PATH;
        $theme_path = get_stylesheet_directory().'/'.DEALERSHIP.'/templates/admin';

        if(file_exists($theme_path.'/'.$layout)){
            return $theme_path.'/'.$layout;
        }elseif(file_exists($base_path.'/'.$layout)){
            return $base_path.'/'.$layout;
        }

        return false;
    }

    public function get_current_screen_post_type() {

        global $post, $typenow, $current_screen;

        if ($post && $post->post_type) return $post->post_type;

        elseif($typenow) return $typenow;

        elseif($current_screen && $current_screen->post_type) return $current_screen->post_type;

        elseif(isset($_REQUEST['post']) && \get_post_type($_REQUEST['post'])) return \get_post_type($_REQUEST['post']);
        elseif(isset($_REQUEST['post_type'])) return sanitize_key($_REQUEST['post_type']);

        return null;

    }
}

