<?php
/*
Plugin Name: DealerShip
Plugin URI: https://github.com/templaza/dearlership
Description: This plugin help you manage permission of advanced products.
Author: Templaza
Version: 1.0.2
Text Domain: dealership
Author URI: http://templaza.com
Forum: https://www.templaza.com/Forums.html
Ticket: https://www.templaza.com/tz_membership/addticket.html
FanPage: https://www.facebook.com/templaza
Twitter: https://twitter.com/templazavn
Google+: https://plus.google.com/+Templaza
*/

namespace DealerShip;

use DealerShip\Admin\AdminSetting;
use DealerShip\TemplazaFramework\TemplazaFrameworkFW;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class DealerShip{

    protected $shortcodes   = array();

    protected static $instance;

    public function __construct()
    {
        $loader = require_once __DIR__."/vendor/autoload.php";

        $this -> hooks();

        // Load settings
        Setting::instance();

        if(\is_admin()) {
            new Admin();
        }else{
            new Frontend();
        }

        $this->register_shortcodes();

        TemplazaFrameworkFW::instance();
    }

    public function hooks(){

        add_action( 'wp_roles_init', array( &$this, 'roles_init' ), 99999 );

        /* Fix issue upload media on front-end (conflict with woocommerce from v7.8.x)
         * This is the hook of woocommerce access to admin
         */
        add_filter('woocommerce_prevent_admin_access', array($this, 'woocommerce_prevent_admin_access'));
    }

    /* Hook to access admin to upload media */
    public function woocommerce_prevent_admin_access($prevent_access){
        if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'upload-attachment'
            && current_user_can('upload_files')){
            return $prevent_access  = false;
        }

        return $prevent_access;

    }

    public function roles_init($wp_roles = null ){

        //Add Dealership role data to WP Roles
        foreach ( $wp_roles->roles as $roleID => $role_data ) {
            $role_meta = get_option( "dls_role_{$roleID}_meta" );

            if ( ! empty( $role_meta ) ) {
                $wp_roles->roles[ $roleID ] = array_merge( $role_data, $role_meta );
            }
        }

        //Add custom Dealership roles
        $roles = array();

        $role_keys = get_option( 'dls_roles', array() );
        foreach ( $role_keys as $role_key ) {
            $role_meta = get_option( "dls_role_{$role_key}_meta" );
            if ( $role_meta ) {
                $roles[ 'dls_' . $role_key ] = $role_meta;
            }
        }

        foreach ( $roles as $role_id => $details ) {
            $capabilities = ! empty( $details['wp_capabilities'] ) ? array_keys( $details['wp_capabilities'] ) : array();
            $details['capabilities'] = array_fill_keys( array_values( $capabilities ), true );
            unset( $details['wp_capabilities'] );
            $wp_roles->roles[ $role_id ]        = $details;
            $wp_roles->role_objects[ $role_id ] = new \WP_Role( $role_id, $details['capabilities'] );
            $wp_roles->role_names[ $role_id ]   = $details['name'];
        }

        // Return the modified $wp_roles array
        return $wp_roles;
    }

    public static function instance(){
        if(static::$instance){
            return static::$instance;
        }

        $instance   = new self();

//        $instance -> hooks();

        static::$instance   = $instance;
        return $instance;
    }

    protected function register_shortcodes(){
        $path   = DEALERSHIP_SHORTCODES_PATH;
        if(!$path || ($path && !is_dir($path))){
            return false;
        }

        $files  = glob($path.'/*.php');

        if(count($files)){
            foreach ($files as $file){
                $info = pathinfo($file);
                $file_name  = $info['filename'];

//                if(!is_file($file)){
//                    $file   .= '/'.$file_name.'.php';
//                }

                $class_name = 'DealerShip\ShortCodes\\'.ucfirst(str_replace('-', '_', $file_name));

                if(class_exists($class_name)){
                    $page_obj  = \call_user_func(array($class_name, 'instance'));
                    $this -> shortcodes[$file_name] = $page_obj;
                }
            }
        }
    }
}


DealerShip::instance();