<?php
namespace Advanced_Product;

use Advanced_Product\Helper\FieldHelper;
use Advanced_Product\Helper\TaxonomyHelper;

defined('ADVANCED_PRODUCT') or exit();

if(!class_exists('Advanced_Product\Custom_Taxonomy')) {
    class Custom_Taxonomy extends Taxonomy
    {
        private $taxonomy   = '';

        protected $prefix   = 'ap_';

        public function __construct( $taxonomy = null, $core = null, $post_type = null)
        {
            $this -> taxonomy   = !empty($taxonomy)?$taxonomy:'';

            parent::__construct($core, $post_type);
        }

        public function hooks()
        {

            parent::hooks(); // TODO: Change the autogenerated stub

            add_filter('advanced-product/ap_product/register_fields', array($this, 'add_fields'));

            add_action( 'admin_menu', array( $this, 'remove_taxonomy_metaboxes' ) );

        }

        public function add_fields($fields){
            $field_names    = wp_list_pluck($fields, 'name');
            $field_index    = array_search('ap_category', $field_names);
            $first_fields   = array_splice($fields, 0 , $field_index + 1);

            $args = array(
                'order'       => 'ASC',
                'orderby'     => 'ID',
                'post_status' => 'publish',
                'post_type'   => 'ap_custom_category',
                'meta_key'    => 'slug',
                'meta_value'  =>  $this -> get_taxonomy_name(),
            );


            $category = get_posts( $args );
            $category = (!empty($category) && is_array($category))?$category[0]:$category;

            if(!empty($category)) {

                $slug       = get_post_meta($category -> ID, 'slug', true);
                $singular   = get_field('singular_name', $category->ID);

                $first_fields[$slug] = wp_parse_args( array(
                    'label' => $singular,
                    'name' => $slug,
                    'type' => 'taxonomy',
                    'taxonomy' => $slug,
                    'sort'          => 2,
//                    'group' => 'overview',
                    'field_type' => 'select',
                    'allow_null' => true
                ), array(
                    'key' => md5('ap_product_'.$category->ID),
                    'label' => '',
                    'name' => '',
                    'type' => 'taxonomy',
                    'instructions' => '',
                    'taxonomy' => '',
                    'field_type' => 'select',
                    'allow_null' => 1,
                    'load_save_terms' => 1,
                    'return_format' => 'id',
                    'multiple' => 0,
                    'sort' => 0,
                    'group' => 'overview'
                ) );
            }
            return array_merge($first_fields, $fields);
        }

        public function register(){

            $taxonomy   = $this -> taxonomy;
            if(!$taxonomy){
                return;
            }

//            $plural     = get_field('plural_name', $taxonomy -> ID);
//            $singular   = get_field('singular_name', $taxonomy -> ID);
            $plural     = get_post_meta($taxonomy -> ID, 'plural_name', true);
            $singular   = get_post_meta($taxonomy -> ID, 'singular_name', true);

            return array(
                'object_type'   => 'ap_product',
                'args'          => array(
                    'label' 					=> $plural,
                    'labels' => array(
                        'name' 					=> $singular,
                        'singular_name' 		=> $singular,
                        'menu_name'				=> $plural,
                        'search_items' 			=> sprintf( __( 'Search %s', 'advanced-product' ), $plural ),
                        'all_items' 			=> sprintf( __( 'All %s', 'advanced-product' ), $plural ),
                        'parent_item' 			=> sprintf( __( 'Parent %s', 'advanced-product' ), $singular ),
                        'parent_item_colon'		=> sprintf( __( 'Parent %s:', 'advanced-product' ), $singular ),
                        'edit_item' 			=> sprintf( __( 'Edit %s', 'advanced-product' ), $singular ),
                        'update_item' 			=> sprintf( __( 'Update %s', 'advanced-product' ), $singular ),
                        'add_new_item' 			=> sprintf( __( 'Add New %s', 'advanced-product' ), $singular ),
                        'new_item_name' 		=> sprintf( __( 'New %s Name', 'advanced-product' ),  $singular ),
                        'not_found' 		    => sprintf( __( 'No %s found.', 'advanced-product' ),  $plural ),
                    ),
                    'hierarchical'              => true,
                    'show_admin_column'         => true,
                    'query_var'                 => false,
                )
            );
        }

        // Get taxonomy name by class name
        public function get_taxonomy_name(){

            $slug   = '';
            if(!empty($this -> taxonomy)) {
//                $slug = get_field('slug', $this->taxonomy->ID);
                $slug   = get_post_meta($this -> taxonomy -> ID, 'slug', true);
            }
            $store_id   = $this -> _get_store_id(__METHOD__, $this -> taxonomy, $slug);

            if(isset($this -> cache[$store_id])){
                return $this -> cache[$store_id];
            }

            $slug       = get_post_meta($this -> taxonomy -> ID, 'slug', true);

            // Return if this is the custom taxonomy
            if(!empty($this -> taxonomy) && $slug){
                $this -> cache[$store_id]   = $slug;
                return $slug;
            }
            return parent::get_taxonomy_name();
        }

        public function __get_core_fields()
        {
            $fields = parent::__get_core_fields();
//            $acfs = apply_filters('acf/get_field_groups', array());
//
//            $associate_to   = get_field('associate_to', $this -> taxonomy -> ID);
            $associate_to   = get_post_meta($this -> taxonomy -> ID, 'associate_to', true);

            $associate_obj  = get_taxonomy( $associate_to);
            $label  = sprintf(__('Associated %s'), $associate_obj -> label);

            $fields[]   = array(
//                'key' => 'field_618b3ce12ae08',
                'key' => 'field_'.md5('taxonomy_'.$this -> taxonomy -> ID),
                'label' => $label,
                'name' => $associate_to,
                'type' => 'taxonomy',
                'taxonomy' => $associate_to,
                'field_type' => 'multi_select',
                'allow_null' => 0,
                'load_save_terms' => 0,
                'return_format' => 'array',
                'multiple' => 1,
//                'instructions' => __('Press and hold the CTRL key and click items in the list to select multiple items. ', 'advanced-product'),
                'default_value' => ''
            );

            return $fields;
        }


        public function manage_edit_columns($columns){
            $columns    = parent::manage_edit_columns($columns);

            $new_columns            = array();
            $new_columns['cb']      = $columns['cb'];
            $new_columns['thumb']   = $columns['thumb'];
            $new_columns['name']    = $columns['name'];

            $associate_to   = get_post_meta($this -> taxonomy -> ID, 'associate_to', true);

            $associate_obj  = get_taxonomy( $associate_to);
            $new_columns[$associate_obj -> name]   = $associate_obj -> label;
//            $new_columns['ap_branch']   = __('Branch', 'advanced-product');

            return array_merge($new_columns, $columns);
        }

        public function manage_custom_column($content, $column, $term_id ){
            $content = parent::manage_custom_column($content, $column, $term_id);

            $associate_to   = get_post_meta($this -> taxonomy -> ID, 'associate_to', true);

            if($column == $associate_to){
//                $ass_taxs = get_field( $associate_to, $this -> get_taxonomy_name().'_'.$term_id );
                $ass_taxs = get_field( $associate_to, 'term_'.$term_id );
                foreach($ass_taxs as $i => $tax){
                    if(is_numeric($tax)) {
                        $term = get_term_by('term_id', $tax, $associate_to);
                    }else{
                        $term = get_term_by('slug', $tax, $associate_to);
                    }
                    $content    .= '<a href="'.get_edit_term_link($term -> term_id, $term -> taxonomy).'">'.$term -> name.'</a>';
                    if($i < count($ass_taxs) - 1) {
                        $content .= '<span>, </span>';
                    }
                }
            }

            return $content;
        }

        /**
         * Removes the default taxonomy metaboxes from the edit screen.
         * We use the advanced custom fields instead and sync the data.
         */
        public function remove_taxonomy_metaboxes(){
            /* Remove meta box is tag */
            \remove_meta_box( 'tagsdiv-'.$this -> get_taxonomy_name(), 'ap_product', 'normal' );

            /* Remove meta box is category */
            \remove_meta_box( $this -> get_taxonomy_name().'div', 'ap_product', 'normal' );
        }
    }
}